/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import com.google.common.collect.Iterables;
import edu.uci.ics.jung.graph.CTreeNetwork;
import edu.uci.ics.jung.graph.MutableCTreeNetwork;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.util.Optional;

public class TreeCollapser {
    public static MutableCTreeNetwork collapse(MutableCTreeNetwork tree, Object subRoot) {
        MutableCTreeNetwork subTree = TreeUtils.getSubTree((CTreeNetwork)tree, (Object)subRoot);
        Optional parent = tree.predecessor(subRoot);
        if (parent.isPresent()) {
            Object parentEdge = Iterables.getOnlyElement((Iterable)tree.inEdges(subRoot));
            tree.removeNode(subRoot);
            tree.addEdge(parent.get(), (Object)subTree, parentEdge);
        } else {
            tree.removeNode(subRoot);
            tree.addNode((Object)subTree);
        }
        return subTree;
    }

    public static MutableCTreeNetwork expand(MutableCTreeNetwork tree, MutableCTreeNetwork subTree) {
        Object parentEdge;
        Optional parent = tree.predecessor((Object)subTree);
        Object object = parentEdge = parent.isPresent() ? Iterables.getOnlyElement((Iterable)tree.inEdges((Object)subTree)) : null;
        if (!subTree.root().isPresent()) {
            return tree;
        }
        tree.removeNode((Object)subTree);
        if (parent.isPresent()) {
            TreeUtils.addSubTree((MutableCTreeNetwork)tree, (CTreeNetwork)subTree, parent.get(), (Object)parentEdge);
            return tree;
        }
        return subTree;
    }
}

