/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.model.PolarPoint;
import edu.uci.ics.jung.visualization.transform.Lens;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Dimension;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HyperbolicTransformer
extends LensTransformer
implements MutableTransformer {
    private static final Logger log = LoggerFactory.getLogger(HyperbolicTransformer.class);

    public HyperbolicTransformer(Dimension d) {
        this(d, (MutableTransformer)new MutableAffineTransformer());
    }

    public HyperbolicTransformer(Dimension d, MutableTransformer delegate) {
        super(d, delegate);
    }

    public HyperbolicTransformer(Lens lens, MutableTransformer delegate) {
        super(lens, delegate);
    }

    @Override
    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Ellipse2D lensEllipse = (Ellipse2D)this.lens.getLensShape();
        if (lensEllipse.contains(graphPoint)) {
            log.trace("lens {} contains graphPoint{}", (Object)lensEllipse, (Object)graphPoint);
        } else {
            log.trace("lens {} does not contain graphPoint {}", (Object)lensEllipse, (Object)graphPoint);
        }
        Point2D viewCenter = this.lens.getCenter();
        double viewRadius = this.lens.getRadius();
        double ratio = this.lens.getRatio();
        Point2D viewPoint = this.delegate.transform(graphPoint);
        if (lensEllipse.contains(viewPoint)) {
            log.trace("lens {} contains viewPoint {}", (Object)lensEllipse, (Object)viewPoint);
        } else {
            log.trace("lens {} does not contain viewPoint {}", (Object)lensEllipse, (Object)viewPoint);
        }
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double theta = polar.theta;
        double radius = polar.radius;
        if (radius > viewRadius) {
            log.trace("outside point radius {} > viewRadius {}", (Object)radius, (Object)viewRadius);
            return viewPoint;
        }
        log.trace("inside point radius {} >= viewRadius {}", (Object)radius, (Object)viewRadius);
        double mag = Math.tan(1.5707963267948966 * (double)this.lens.getMagnification());
        radius *= mag;
        radius = Math.min(radius, viewRadius);
        radius /= viewRadius;
        radius *= 1.5707963267948966;
        radius = Math.abs(Math.atan(radius));
        Point projectedPoint = PolarPoint.polarToCartesian((double)theta, (double)(radius *= viewRadius));
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + viewCenter.getX(), projectedPoint.y + viewCenter.getY());
        return translatedBack;
    }

    @Override
    public Point2D inverseTransform(Point2D viewPoint) {
        Ellipse2D lensEllipse = (Ellipse2D)this.lens.getLensShape();
        if (lensEllipse.contains(viewPoint)) {
            log.trace("lens {} contains viewPoint{}", (Object)lensEllipse, (Object)viewPoint);
        } else {
            log.trace("lens {} does not contain viewPoint {}", (Object)lensEllipse, (Object)viewPoint);
        }
        Point2D viewCenter = this.lens.getCenter();
        double viewRadius = this.lens.getRadius();
        double ratio = this.lens.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double radius = polar.radius;
        if (radius > viewRadius) {
            log.trace("outside point radius {} > viewRadius {}", (Object)radius, (Object)viewRadius);
        } else {
            log.trace("inside point radius {} <= viewRadius {}", (Object)radius, (Object)viewRadius);
        }
        if (radius > viewRadius) {
            return this.delegate.inverseTransform(viewPoint);
        }
        radius /= viewRadius;
        radius = Math.abs(Math.tan(radius));
        radius /= 1.5707963267948966;
        radius *= viewRadius;
        double mag = Math.tan(1.5707963267948966 * (double)this.lens.getMagnification());
        polar = polar.newRadius(radius /= mag);
        Point projectedPoint = PolarPoint.polarToCartesian((PolarPoint)polar);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + viewCenter.getX(), projectedPoint.y + viewCenter.getY());
        return this.delegate.inverseTransform(translatedBack);
    }
}

