/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.LensTransformSupport;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalLensGraphMouse;
import edu.uci.ics.jung.visualization.control.TransformSupport;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.HyperbolicTransformer;
import edu.uci.ics.jung.visualization.transform.Lens;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutLensSupport<N, E>
extends AbstractLensSupport<N, E>
implements LensSupport {
    private static final Logger log = LoggerFactory.getLogger(LayoutLensSupport.class);
    protected NetworkElementAccessor<N, E> pickSupport;

    public LayoutLensSupport(VisualizationViewer<N, E> vv) {
        this(vv, new HyperbolicTransformer(new Lens(vv.getModel().getLayoutSize()), vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT)), new ModalLensGraphMouse());
    }

    public LayoutLensSupport(VisualizationViewer<N, E> vv, Lens lens) {
        this(vv, new HyperbolicTransformer(lens, vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT)), new ModalLensGraphMouse());
    }

    public LayoutLensSupport(VisualizationViewer<N, E> vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.lensTransformer = lensTransformer;
        this.pickSupport = vv.getPickSupport();
    }

    @Override
    public void activate() {
        if (this.lensPaintable == null) {
            this.lensPaintable = new AbstractLensSupport.LensPaintable(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, this.lensTransformer);
        this.vv.prependPreRenderPaintable(this.lensPaintable);
        this.vv.addPostRenderPaintable(this.lensControls);
        this.vv.setGraphMouse(this.lensGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.setTransformSupport(new LensTransformSupport());
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        if (this.lensTransformer != null) {
            this.vv.removePreRenderPaintable(this.lensPaintable);
            this.vv.removePostRenderPaintable(this.lensControls);
            this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.LAYOUT, this.lensTransformer.getDelegate());
        }
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.setTransformSupport(new TransformSupport());
        this.vv.repaint();
    }
}

