/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.model.PolarPoint;
import edu.uci.ics.jung.visualization.transform.Lens;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableAffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MagnifyTransformer
extends LensTransformer
implements MutableTransformer {
    private static final Logger log = LoggerFactory.getLogger(MagnifyTransformer.class);

    public MagnifyTransformer(Dimension d) {
        this(d, (MutableTransformer)new MutableAffineTransformer());
    }

    public MagnifyTransformer(Lens lens) {
        this(lens, (MutableTransformer)new MutableAffineTransformer());
    }

    public MagnifyTransformer(Dimension d, MutableTransformer delegate) {
        super(d, delegate);
    }

    public MagnifyTransformer(Lens lens, MutableTransformer delegate) {
        super(lens, delegate);
    }

    @Override
    public Point2D transform(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.lens.getCenter();
        double viewRadius = this.lens.getRadius();
        double ratio = this.lens.getRatio();
        Point2D viewPoint = this.delegate.transform(graphPoint);
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double theta = polar.theta;
        double radius = polar.radius;
        if (radius > viewRadius) {
            return viewPoint;
        }
        double mag = this.lens.getMagnification();
        radius *= mag;
        radius = Math.min(radius, viewRadius);
        Point projectedPoint = PolarPoint.polarToCartesian((double)theta, (double)radius);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + viewCenter.getX(), projectedPoint.y + viewCenter.getY());
        return translatedBack;
    }

    @Override
    public Point2D inverseTransform(Point2D viewPoint) {
        Point2D viewCenter = this.lens.getCenter();
        double viewRadius = this.lens.getRadius();
        double ratio = this.lens.getRatio();
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double radius = polar.radius;
        if (radius > viewRadius) {
            return this.delegate.inverseTransform(viewPoint);
        }
        double mag = this.lens.getMagnification();
        polar = polar.newRadius(radius /= mag);
        Point projectedPoint = PolarPoint.polarToCartesian((PolarPoint)polar);
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + viewCenter.getX(), projectedPoint.y + viewCenter.getY());
        return this.delegate.inverseTransform(translatedBack);
    }

    public Point2D magnify(Point2D graphPoint) {
        if (graphPoint == null) {
            return null;
        }
        Point2D viewCenter = this.lens.getCenter();
        double ratio = this.lens.getRatio();
        Point2D viewPoint = graphPoint;
        double dx = viewPoint.getX() - viewCenter.getX();
        double dy = viewPoint.getY() - viewCenter.getY();
        Point pointFromCenter = Point.of((double)(dx *= ratio), (double)dy);
        PolarPoint polar = PolarPoint.cartesianToPolar((Point)pointFromCenter);
        double theta = polar.theta;
        double radius = polar.radius;
        double mag = this.lens.getMagnification();
        Point projectedPoint = PolarPoint.polarToCartesian((double)theta, (double)(radius *= mag));
        projectedPoint = Point.of((double)(projectedPoint.x / ratio), (double)projectedPoint.y);
        Point2D.Double translatedBack = new Point2D.Double(projectedPoint.x + viewCenter.getX(), projectedPoint.y + viewCenter.getY());
        return translatedBack;
    }
}

