/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform.shape;

import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.LensTransformSupport;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.TransformSupport;
import edu.uci.ics.jung.visualization.layout.NetworkElementAccessor;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.AbstractLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.TransformingFlatnessGraphics;
import java.awt.Dimension;

public class ViewLensSupport<N, E>
extends AbstractLensSupport<N, E>
implements LensSupport {
    protected RenderContext<N, E> renderContext;
    protected GraphicsDecorator lensGraphicsDecorator;
    protected GraphicsDecorator savedGraphicsDecorator;
    protected NetworkElementAccessor<N, E> pickSupport;
    protected Renderer.Edge<N, E> savedEdgeRenderer;
    protected Renderer.Edge<N, E> reshapingEdgeRenderer;

    public ViewLensSupport(VisualizationViewer<N, E> vv, LensTransformer lensTransformer, ModalGraphMouse lensGraphMouse) {
        super(vv, lensGraphMouse);
        this.renderContext = vv.getRenderContext();
        this.pickSupport = this.renderContext.getPickSupport();
        this.savedGraphicsDecorator = this.renderContext.getGraphicsContext();
        this.lensTransformer = lensTransformer;
        LayoutModel layoutModel = vv.getModel().getLayoutModel();
        Dimension d = new Dimension(layoutModel.getWidth(), layoutModel.getHeight());
        lensTransformer.getLens().setSize(d);
        this.lensGraphicsDecorator = new TransformingFlatnessGraphics(lensTransformer);
        this.savedEdgeRenderer = vv.getRenderer().getEdgeRenderer();
    }

    @Override
    public void activate() {
        this.lensTransformer.setDelegate(this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.VIEW));
        if (this.lensPaintable == null) {
            this.lensPaintable = new AbstractLensSupport.LensPaintable(this.lensTransformer);
        }
        if (this.lensControls == null) {
            this.lensControls = new AbstractLensSupport.LensControls(this.lensTransformer);
        }
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, this.lensTransformer);
        this.renderContext.setGraphicsContext(this.lensGraphicsDecorator);
        this.vv.prependPreRenderPaintable(this.lensPaintable);
        this.vv.addPostRenderPaintable(this.lensControls);
        this.vv.setGraphMouse(this.lensGraphMouse);
        this.vv.setToolTipText("<html><center>Mouse-Drag the Lens center to move it<p>Mouse-Drag the Lens edge to resize it<p>Ctrl+MouseWheel to change magnification</center></html>");
        this.vv.setTransformSupport(new LensTransformSupport());
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(MultiLayerTransformer.Layer.VIEW, this.lensTransformer.getDelegate());
        this.vv.removePreRenderPaintable(this.lensPaintable);
        this.vv.removePostRenderPaintable(this.lensControls);
        this.renderContext.setGraphicsContext(this.savedGraphicsDecorator);
        this.vv.setRenderContext(this.renderContext);
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.setGraphMouse(this.graphMouse);
        this.vv.setTransformSupport(new TransformSupport());
        this.vv.repaint();
    }
}

