/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml;

import com.google.common.base.Preconditions;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.GraphReader;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.GraphMLDocument;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.Key;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.ElementParserRegistry;
import edu.uci.ics.jung.io.graphml.parser.GraphMLEventFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.function.Function;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class GraphMLReader2<G extends MutableNetwork<N, E>, N, E>
implements GraphReader<G, N, E> {
    protected XMLEventReader xmlEventReader;
    protected Reader fileReader;
    protected Function<GraphMetadata, G> graphTransformer;
    protected Function<NodeMetadata, N> nodeTransformer;
    protected Function<EdgeMetadata, E> edgeTransformer;
    protected boolean initialized;
    protected final GraphMLDocument document = new GraphMLDocument();
    protected final ElementParserRegistry<G, N, E> parserRegistry;
    private InputStream inputStream;

    public GraphMLReader2(Reader fileReader, Function<GraphMetadata, G> graphTransformer, Function<NodeMetadata, N> nodeTransformer, Function<EdgeMetadata, E> edgeTransformer) {
        this.fileReader = (Reader)Preconditions.checkNotNull((Object)fileReader);
        this.graphTransformer = (Function)Preconditions.checkNotNull(graphTransformer);
        this.nodeTransformer = (Function)Preconditions.checkNotNull(nodeTransformer);
        this.edgeTransformer = (Function)Preconditions.checkNotNull(edgeTransformer);
        this.parserRegistry = new ElementParserRegistry<G, N, E>(this.document.getKeyMap(), graphTransformer, nodeTransformer, edgeTransformer);
    }

    public GraphMLReader2(InputStream inputStream, Function<GraphMetadata, G> graphTransformer, Function<NodeMetadata, N> nodeTransformer, Function<EdgeMetadata, E> edgeTransformer) {
        this.inputStream = (InputStream)Preconditions.checkNotNull((Object)inputStream);
        this.graphTransformer = (Function)Preconditions.checkNotNull(graphTransformer);
        this.nodeTransformer = (Function)Preconditions.checkNotNull(nodeTransformer);
        this.edgeTransformer = (Function)Preconditions.checkNotNull(edgeTransformer);
        this.parserRegistry = new ElementParserRegistry<G, N, E>(this.document.getKeyMap(), graphTransformer, nodeTransformer, edgeTransformer);
    }

    public Function<GraphMetadata, G> getGraphTransformer() {
        return this.graphTransformer;
    }

    public Function<NodeMetadata, N> getNodeTransformer() {
        return this.nodeTransformer;
    }

    public Function<EdgeMetadata, E> getEdgeTransformer() {
        return this.edgeTransformer;
    }

    public void init() throws GraphIOException {
        try {
            if (!this.initialized) {
                XMLInputFactory Supplier2 = XMLInputFactory.newInstance();
                this.xmlEventReader = this.fileReader == null && this.inputStream != null ? Supplier2.createXMLEventReader(this.inputStream) : Supplier2.createXMLEventReader(this.fileReader);
                this.xmlEventReader = Supplier2.createFilteredReader(this.xmlEventReader, new GraphMLEventFilter());
                this.initialized = true;
            }
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
        }
    }

    @Override
    public void close() throws GraphIOException {
        try {
            this.document.clear();
            if (this.xmlEventReader != null) {
                this.xmlEventReader.close();
            }
            if (this.fileReader != null) {
                this.fileReader.close();
            }
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw new GraphIOException(e);
        }
        catch (XMLStreamException e) {
            throw new GraphIOException(e);
        }
        finally {
            this.fileReader = null;
            this.inputStream = null;
            this.xmlEventReader = null;
            this.graphTransformer = null;
            this.nodeTransformer = null;
            this.edgeTransformer = null;
        }
    }

    public GraphMLDocument getGraphMLDocument() {
        return this.document;
    }

    @Override
    public G readGraph() throws GraphIOException {
        try {
            this.init();
            while (this.xmlEventReader.hasNext()) {
                XMLEvent event = this.xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("key".equals(name)) {
                        Key key = (Key)this.parserRegistry.getParser(name).parse(this.xmlEventReader, element);
                        this.document.getKeyMap().addKey(key);
                        continue;
                    }
                    if ("graph".equals(name)) {
                        GraphMetadata graph = (GraphMetadata)this.parserRegistry.getParser(name).parse(this.xmlEventReader, element);
                        this.document.getGraphMetadata().add(graph);
                        return (G)((MutableNetwork)graph.getGraph());
                    }
                    if ("graphml".equals(name)) continue;
                    this.parserRegistry.getUnknownElementParser().parse(this.xmlEventReader, element);
                    continue;
                }
                if (!event.isEndDocument()) continue;
                break;
            }
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
        }
        throw new GraphIOException("Unable to read Graph from document - the document could be empty");
    }
}

