/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.DataMetadata;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class EdgeElementParser<G extends MutableNetwork<N, E>, N, E>
extends AbstractElementParser<G, N, E> {
    public EdgeElementParser(ParserContext<G, N, E> parserContext) {
        super(parserContext);
    }

    @Override
    public EdgeMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            EdgeMetadata edge = new EdgeMetadata();
            Iterator<Attribute> iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (edge.getId() == null && "id".equals(name)) {
                    edge.setId(value);
                    continue;
                }
                if (edge.isDirected() == null && "directed".equals(name)) {
                    edge.setDirected("true".equals(value));
                    continue;
                }
                if (edge.getSource() == null && "source".equals(name)) {
                    edge.setSource(value);
                    continue;
                }
                if (edge.getTarget() == null && "target".equals(name)) {
                    edge.setTarget(value);
                    continue;
                }
                if (edge.getSourcePort() == null && "sourceport".equals(name)) {
                    edge.setSourcePort(value);
                    continue;
                }
                if (edge.getTargetPort() == null && "targetport".equals(name)) {
                    edge.setTargetPort(value);
                    continue;
                }
                edge.setProperty(name, value);
            }
            if (edge.getSource() == null || edge.getTarget() == null) {
                throw new GraphIOException("Element 'edge' is missing attribute 'source' or 'target'");
            }
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("desc".equals(name)) {
                        String desc = (String)this.getParser(name).parse(xmlEventReader, element);
                        edge.setDescription(desc);
                    } else if ("data".equals(name)) {
                        DataMetadata data = (DataMetadata)this.getParser(name).parse(xmlEventReader, element);
                        edge.addData(data);
                    } else {
                        this.getUnknownParser().parse(xmlEventReader, element);
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            this.applyKeys(edge);
            return edge;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

