/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.KeyMap;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.DataElementParser;
import edu.uci.ics.jung.io.graphml.parser.EdgeElementParser;
import edu.uci.ics.jung.io.graphml.parser.ElementParser;
import edu.uci.ics.jung.io.graphml.parser.EndpointElementParser;
import edu.uci.ics.jung.io.graphml.parser.GraphElementParser;
import edu.uci.ics.jung.io.graphml.parser.KeyElementParser;
import edu.uci.ics.jung.io.graphml.parser.NodeElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import edu.uci.ics.jung.io.graphml.parser.PortElementParser;
import edu.uci.ics.jung.io.graphml.parser.StringElementParser;
import edu.uci.ics.jung.io.graphml.parser.UnknownElementParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class ElementParserRegistry<G extends MutableNetwork<N, E>, N, E> {
    private final Map<String, ElementParser> parserMap = new HashMap<String, ElementParser>();
    private final ElementParser unknownElementParser = new UnknownElementParser();

    public ElementParserRegistry(KeyMap keyMap, Function<GraphMetadata, G> graphTransformer, Function<NodeMetadata, N> nodeTransformer, Function<EdgeMetadata, E> edgeTransformer) {
        ParserContext<G, N, E> context = new ParserContext<G, N, E>(this, keyMap, graphTransformer, nodeTransformer, edgeTransformer);
        this.parserMap.put("default", new StringElementParser<G, N, E>(context));
        this.parserMap.put("desc", new StringElementParser<G, N, E>(context));
        this.parserMap.put("key", new KeyElementParser<G, N, E>(context));
        this.parserMap.put("data", new DataElementParser<G, N, E>(context));
        this.parserMap.put("port", new PortElementParser<G, N, E>(context));
        this.parserMap.put("node", new NodeElementParser<G, N, E>(context));
        this.parserMap.put("graph", new GraphElementParser<G, N, E>(context));
        this.parserMap.put("endpoint", new EndpointElementParser<G, N, E>(context));
        this.parserMap.put("edge", new EdgeElementParser<G, N, E>(context));
    }

    public ElementParser getUnknownElementParser() {
        return this.unknownElementParser;
    }

    public ElementParser getParser(String localName) {
        ElementParser parser = this.parserMap.get(localName);
        if (parser == null) {
            parser = this.unknownElementParser;
        }
        return parser;
    }
}

