/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StringElementParser<G extends MutableNetwork<N, E>, N, E>
extends AbstractElementParser<G, N, E> {
    public StringElementParser(ParserContext<G, N, E> parserContext) {
        super(parserContext);
    }

    @Override
    public String parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            String str = null;
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    this.getUnknownParser().parse(xmlEventReader, event.asStartElement());
                    continue;
                }
                if (event.isEndElement()) {
                    EndElement end = (EndElement)event;
                    this.verifyMatch(start, end);
                    break;
                }
                if (!event.isCharacters()) continue;
                Characters characters = (Characters)event;
                str = characters.getData();
            }
            return str;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

