/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.scoring.BetweennessCentrality;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Function;

public class EdgeBetweennessClusterer<N, E>
implements Function<Network<N, E>, Set<Set<N>>> {
    private final int mNumEdgesToRemove;
    private LinkedHashSet<E> edgesRemoved;

    public EdgeBetweennessClusterer(int numEdgesToRemove) {
        Preconditions.checkArgument((numEdgesToRemove >= 0 ? 1 : 0) != 0, (Object)"Number of edges to remove must be positive");
        this.mNumEdgesToRemove = numEdgesToRemove;
        this.edgesRemoved = new LinkedHashSet(this.mNumEdgesToRemove);
    }

    @Override
    public Set<Set<N>> apply(Network<N, E> graph) {
        Preconditions.checkArgument((this.mNumEdgesToRemove <= graph.edges().size() ? 1 : 0) != 0, (Object)"Number of edges to remove must be <= the number of edges in the graph");
        MutableNetwork filtered = Graphs.copyOf(graph);
        this.edgesRemoved.clear();
        for (int k = 0; k < this.mNumEdgesToRemove; ++k) {
            BetweennessCentrality bc = new BetweennessCentrality(filtered);
            Object to_remove = null;
            double score = 0.0;
            for (Object e : filtered.edges()) {
                if (!((Double)bc.getEdgeScore(e) > score)) continue;
                to_remove = e;
                score = (Double)bc.getEdgeScore(e);
            }
            this.edgesRemoved.add(to_remove);
            filtered.removeEdge(to_remove);
        }
        WeakComponentClusterer wcSearch = new WeakComponentClusterer();
        Set clusterSet = wcSearch.apply(filtered);
        return clusterSet;
    }

    public Set<E> getEdgesRemoved() {
        return this.edgesRemoved;
    }
}

