/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.flows;

import com.google.common.base.Preconditions;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.util.IterativeProcess;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class EdmondsKarpMaxFlow<N, E>
extends IterativeProcess {
    private MutableNetwork<N, E> flowNetwork;
    private Network<N, E> network;
    private N source;
    private N target;
    private int maxFlow;
    private Set<N> sourcePartitionNodes;
    private Set<N> sinkPartitionNodes;
    private Set<E> minCutEdges;
    private Map<E, Integer> residualCapacityMap = new HashMap<E, Integer>();
    private Map<N, N> parentMap = new HashMap<N, N>();
    private Map<N, Integer> parentCapacityMap = new HashMap<N, Integer>();
    private Function<E, Integer> edgeCapacityTransformer;
    private Map<E, Integer> edgeFlowMap;
    private Supplier<E> edgeFactory;

    public EdmondsKarpMaxFlow(Network<N, E> network, N source, N sink, Function<E, Integer> edgeCapacityTransformer, Map<E, Integer> edgeFlowMap, Supplier<E> edgeFactory) {
        Preconditions.checkArgument((boolean)network.isDirected(), (Object)"input graph must be directed");
        Preconditions.checkArgument((boolean)network.nodes().contains(source), (Object)"input graph must contain source node");
        Preconditions.checkArgument((boolean)network.nodes().contains(sink), (Object)"input graph must contain sink node");
        Preconditions.checkArgument((!source.equals(sink) ? 1 : 0) != 0, (Object)"source and sink nodes must be distinct");
        this.network = network;
        this.source = source;
        this.target = sink;
        this.edgeFlowMap = edgeFlowMap;
        this.edgeCapacityTransformer = edgeCapacityTransformer;
        this.edgeFactory = edgeFactory;
        this.flowNetwork = Graphs.copyOf(network);
        this.maxFlow = 0;
        this.sinkPartitionNodes = new HashSet<N>();
        this.sourcePartitionNodes = new HashSet<N>();
        this.minCutEdges = new HashSet();
    }

    private void clearParentValues() {
        this.parentMap.clear();
        this.parentCapacityMap.clear();
        this.parentCapacityMap.put(this.source, Integer.MAX_VALUE);
        this.parentMap.put(this.source, this.source);
    }

    protected boolean hasAugmentingPath() {
        this.sinkPartitionNodes.clear();
        this.sourcePartitionNodes.clear();
        this.sinkPartitionNodes.addAll(this.flowNetwork.nodes());
        HashSet visitedEdgesMap = new HashSet();
        LinkedList<Object> queue = new LinkedList<Object>();
        queue.add(this.source);
        while (!queue.isEmpty()) {
            Object currentNode = queue.remove();
            this.sinkPartitionNodes.remove(currentNode);
            this.sourcePartitionNodes.add(currentNode);
            Integer currentCapacity = this.parentCapacityMap.get(currentNode);
            for (Object neighboringEdge : this.flowNetwork.outEdges(currentNode)) {
                Object neighboringNode = this.flowNetwork.incidentNodes(neighboringEdge).target();
                Integer residualCapacity = this.residualCapacityMap.get(neighboringEdge);
                if (residualCapacity <= 0 || visitedEdgesMap.contains(neighboringEdge)) continue;
                N neighborsParent = this.parentMap.get(neighboringNode);
                Integer neighborCapacity = this.parentCapacityMap.get(neighboringNode);
                int newCapacity = Math.min(residualCapacity, currentCapacity);
                if (neighborsParent != null && newCapacity <= neighborCapacity) continue;
                this.parentMap.put(neighboringNode, currentNode);
                this.parentCapacityMap.put(neighboringNode, newCapacity);
                visitedEdgesMap.add(neighboringEdge);
                if (neighboringNode == this.target) continue;
                queue.add(neighboringNode);
            }
        }
        boolean hasAugmentingPath = false;
        Integer targetsParentCapacity = this.parentCapacityMap.get(this.target);
        if (targetsParentCapacity != null && targetsParentCapacity > 0) {
            this.updateResidualCapacities();
            hasAugmentingPath = true;
        }
        this.clearParentValues();
        return hasAugmentingPath;
    }

    @Override
    public void step() {
        while (this.hasAugmentingPath()) {
        }
        this.computeMinCut();
    }

    private void computeMinCut() {
        for (Object e : this.network.edges()) {
            EndpointPair endpoints = this.network.incidentNodes(e);
            Object source = endpoints.source();
            Object destination = endpoints.target();
            if (this.sinkPartitionNodes.contains(source) && this.sinkPartitionNodes.contains(destination) || this.sourcePartitionNodes.contains(source) && this.sourcePartitionNodes.contains(destination) || this.sinkPartitionNodes.contains(source) && this.sourcePartitionNodes.contains(destination)) continue;
            this.minCutEdges.add(e);
        }
    }

    public int getMaxFlow() {
        return this.maxFlow;
    }

    public Set<N> getNodesInSinkPartition() {
        return this.sinkPartitionNodes;
    }

    public Set<N> getNodesInSourcePartition() {
        return this.sourcePartitionNodes;
    }

    public Set<E> getMinCutEdges() {
        return this.minCutEdges;
    }

    public Network<N, E> getFlowGraph() {
        return this.flowNetwork;
    }

    @Override
    protected void initializeIterations() {
        this.parentCapacityMap.put(this.source, Integer.MAX_VALUE);
        this.parentMap.put(this.source, this.source);
        HashSet<EndpointPair> backEdges = new HashSet<EndpointPair>();
        for (Object edge : this.flowNetwork.edges()) {
            Integer capacity = this.edgeCapacityTransformer.apply(edge);
            Preconditions.checkNotNull((Object)capacity, (Object)"Edge capacities must exist for all edges");
            this.residualCapacityMap.put(edge, capacity);
            EndpointPair endpoints = this.flowNetwork.incidentNodes(edge);
            Object source = endpoints.source();
            Object destination = endpoints.target();
            if (this.flowNetwork.successors(destination).contains(source)) continue;
            backEdges.add(EndpointPair.ordered((Object)destination, (Object)source));
        }
        for (EndpointPair endpoints : backEdges) {
            E backEdge = this.edgeFactory.get();
            this.flowNetwork.addEdge(endpoints.source(), endpoints.target(), backEdge);
            this.residualCapacityMap.put(backEdge, 0);
        }
    }

    @Override
    protected void finalizeIterations() {
        for (Object currentEdge : this.flowNetwork.edges()) {
            Integer capacity = this.edgeCapacityTransformer.apply(currentEdge);
            Integer residualCapacity = this.residualCapacityMap.get(currentEdge);
            if (capacity == null) continue;
            Integer flowValue = capacity - residualCapacity;
            this.edgeFlowMap.put(currentEdge, flowValue);
        }
        HashSet backEdges = new HashSet();
        for (Object currentEdge : this.flowNetwork.edges()) {
            if (this.edgeCapacityTransformer.apply(currentEdge) == null) {
                backEdges.add(currentEdge);
                continue;
            }
            this.residualCapacityMap.remove(currentEdge);
        }
        for (Object e : backEdges) {
            this.flowNetwork.removeEdge(e);
        }
    }

    private void updateResidualCapacities() {
        Integer augmentingPathCapacity = this.parentCapacityMap.get(this.target);
        this.maxFlow += augmentingPathCapacity.intValue();
        N currentNode = this.target;
        Object parentNode = null;
        while (true) {
            N n = this.parentMap.get(currentNode);
            parentNode = n;
            if (n == currentNode) break;
            Object currentEdge = this.flowNetwork.edgesConnecting(parentNode, currentNode).iterator().next();
            Integer residualCapacity = this.residualCapacityMap.get(currentEdge);
            residualCapacity = residualCapacity - augmentingPathCapacity;
            this.residualCapacityMap.put(currentEdge, residualCapacity);
            Object backEdge = this.flowNetwork.edgesConnecting(currentNode, parentNode).iterator().next();
            residualCapacity = this.residualCapacityMap.get(backEdge);
            residualCapacity = residualCapacity + augmentingPathCapacity;
            this.residualCapacityMap.put(backEdge, residualCapacity);
            currentNode = parentNode;
        }
    }
}

