/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;

public class EppsteinPowerLawGenerator<N> {
    private int nodeCount;
    private int edgeCount;
    private int mNumIterations;
    private double mMaxDegree;
    private Random mRandom;
    private Supplier<N> nodeFactory;
    private List<N> nodes;

    public EppsteinPowerLawGenerator(Supplier<N> nodeFactory, int numNodes, int numEdges, int r) {
        this.nodeFactory = nodeFactory;
        this.nodeCount = numNodes;
        this.edgeCount = numEdges;
        this.mNumIterations = r;
        this.mRandom = new Random();
    }

    protected MutableGraph<N> initializeGraph() {
        MutableGraph graph = GraphBuilder.undirected().build();
        this.nodes = new ArrayList<N>(this.nodeCount);
        for (int i = 0; i < this.nodeCount; ++i) {
            N node = this.nodeFactory.get();
            graph.addNode(node);
            this.nodes.add(node);
        }
        while (graph.edges().size() < this.edgeCount) {
            N v;
            N u = this.nodes.get((int)(this.mRandom.nextDouble() * (double)this.nodeCount));
            if (u.equals(v = this.nodes.get((int)(this.mRandom.nextDouble() * (double)this.nodeCount)))) continue;
            graph.putEdge(u, v);
        }
        double maxDegree = 0.0;
        for (Object v : graph.nodes()) {
            maxDegree = Math.max((double)graph.degree(v), maxDegree);
        }
        this.mMaxDegree = maxDegree;
        return graph;
    }

    public Graph<N> get() {
        MutableGraph<N> graph = this.initializeGraph();
        for (int rIdx = 0; rIdx < this.mNumIterations; ++rIdx) {
            Object v = null;
            while (graph.degree(v = this.nodes.get((int)(this.mRandom.nextDouble() * (double)this.nodeCount))) == 0) {
            }
            Set neighbors = graph.adjacentNodes(v);
            int neighborIndex = (int)(this.mRandom.nextDouble() * (double)neighbors.size());
            int i = 0;
            Object w = null;
            for (Object neighbor : graph.adjacentNodes(v)) {
                if (i++ != neighborIndex) continue;
                w = neighbor;
                break;
            }
            N x = this.nodes.get((int)(this.mRandom.nextDouble() * (double)this.nodeCount));
            Object y = null;
            do {
                y = this.nodes.get((int)(this.mRandom.nextDouble() * (double)this.nodeCount));
            } while (this.mRandom.nextDouble() > (double)(graph.degree(y) + 1) / this.mMaxDegree);
            if (x.equals(y) || graph.successors(x).contains(y)) continue;
            graph.removeEdge(v, w);
            graph.putEdge(x, y);
        }
        return graph;
    }

    public void setRandom(Random random) {
        this.mRandom = random;
    }
}

