/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorer;
import edu.uci.ics.jung.algorithms.scoring.NodeScorer;
import java.util.function.Function;

public abstract class AbstractIterativeScorerWithPriors<N, E, S>
extends AbstractIterativeScorer<N, E, S>
implements NodeScorer<N, S> {
    protected Function<? super N, ? extends S> node_priors;
    protected double alpha;

    public AbstractIterativeScorerWithPriors(Network<N, E> g, Function<? super E, ? extends Number> edge_weights, Function<? super N, ? extends S> node_priors, double alpha) {
        super(g, edge_weights);
        this.node_priors = node_priors;
        this.alpha = alpha;
        this.initialize();
    }

    public AbstractIterativeScorerWithPriors(Network<N, E> g, Function<N, ? extends S> node_priors, double alpha) {
        super(g);
        this.node_priors = node_priors;
        this.alpha = alpha;
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
        for (Object v : this.graph.nodes()) {
            this.setOutputValue(v, this.getNodePrior(v));
        }
    }

    protected S getNodePrior(N v) {
        return this.node_priors.apply(v);
    }

    public Function<? super N, ? extends S> getNodePriors() {
        return this.node_priors;
    }

    public double getAlpha() {
        return this.alpha;
    }
}

