/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.NodeScorer;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class DistanceCentralityScorer<N, E>
implements NodeScorer<N, Double> {
    protected Graph<N> graph;
    protected Distance<N> distance;
    protected Map<N, Double> output;
    protected boolean averaging;
    protected boolean ignore_missing;
    protected boolean ignore_self_distances;

    public DistanceCentralityScorer(Network<N, E> graph, Distance<N> distance, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this.graph = graph.asGraph();
        this.distance = distance;
        this.averaging = averaging;
        this.ignore_missing = ignore_missing;
        this.ignore_self_distances = ignore_self_distances;
        this.output = new HashMap<N, Double>();
    }

    public DistanceCentralityScorer(Graph<N> graph, Distance<N> distance, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this.graph = graph;
        this.distance = distance;
        this.averaging = averaging;
        this.ignore_missing = ignore_missing;
        this.ignore_self_distances = ignore_self_distances;
        this.output = new HashMap<N, Double>();
    }

    public DistanceCentralityScorer(Network<N, E> graph, Distance<N> distance, boolean averaging) {
        this(graph, distance, averaging, true, true);
    }

    public DistanceCentralityScorer(Network<N, E> graph, Function<E, ? extends Number> edge_weights, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this(graph, new DijkstraDistance<N, E>(graph, edge_weights), averaging, ignore_missing, ignore_self_distances);
    }

    public DistanceCentralityScorer(Network<N, E> graph, Function<E, ? extends Number> edge_weights, boolean averaging) {
        this(graph, new DijkstraDistance<N, E>(graph, edge_weights), averaging, true, true);
    }

    public DistanceCentralityScorer(Graph<N> graph, boolean averaging, boolean ignore_missing, boolean ignore_self_distances) {
        this(graph, new UnweightedShortestPath<N>(graph), averaging, ignore_missing, ignore_self_distances);
    }

    public DistanceCentralityScorer(Graph<N> graph, boolean averaging) {
        this(graph, new UnweightedShortestPath<N>(graph), averaging, true, true);
    }

    @Override
    public Double getNodeScore(N v) {
        Double value = this.output.get(v);
        if (value != null) {
            if (value < 0.0) {
                return null;
            }
            return value;
        }
        HashMap<N, Number> v_distances = new HashMap<N, Number>(this.distance.getDistanceMap(v));
        if (this.ignore_self_distances) {
            v_distances.remove(v);
        }
        if (!this.ignore_missing) {
            int num_dests = this.graph.nodes().size() - (this.ignore_self_distances ? 1 : 0);
            if (v_distances.size() != num_dests) {
                this.output.put(v, -1.0);
                return null;
            }
        }
        Double sum = 0.0;
        for (Object w : this.graph.nodes()) {
            if (w.equals(v) && this.ignore_self_distances) continue;
            Number w_distance = (Number)v_distances.get(w);
            if (w_distance == null) {
                if (this.ignore_missing) continue;
                this.output.put(v, -1.0);
                return null;
            }
            sum = sum + w_distance.doubleValue();
        }
        value = sum;
        if (this.averaging) {
            value = value / (double)v_distances.size();
        }
        double score = value == 0.0 ? Double.POSITIVE_INFINITY : 1.0 / value;
        this.output.put(v, score);
        return score;
    }

    @Override
    public Map<N, Double> nodeScores() {
        return Maps.asMap((Set)this.graph.nodes(), node -> this.getNodeScore(node));
    }
}

