/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Preconditions;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.algorithms.scoring.NodeScorer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class WeightedNIPaths<N, E>
implements NodeScorer<N, Double> {
    private final MutableNetwork<N, E> graph;
    private final double alpha;
    private final int maxDepth;
    private final Set<N> priors;
    private final Map<E, Number> pathIndices = new HashMap<E, Number>();
    private final Map<Object, N> roots = new HashMap<Object, N>();
    private final Map<N, Set<Number>> pathsSeenMap = new HashMap<N, Set<Number>>();
    private final Map<N, Double> nodeScores = new LinkedHashMap<N, Double>();
    private final Supplier<N> nodeFactory;
    private final Supplier<E> edgeFactory;

    public WeightedNIPaths(MutableNetwork<N, E> graph, Supplier<N> nodeFactory, Supplier<E> edgeFactory, double alpha, int maxDepth, Set<N> priors) {
        Preconditions.checkArgument((boolean)graph.isDirected(), (Object)"Input graph must be directed");
        this.graph = graph;
        this.nodeFactory = nodeFactory;
        this.edgeFactory = edgeFactory;
        this.alpha = alpha;
        this.maxDepth = maxDepth;
        this.priors = priors;
        this.evaluate();
    }

    protected void incrementRankScore(N node, double rankValue) {
        this.nodeScores.computeIfPresent(node, (v, value) -> value + rankValue);
    }

    protected void computeWeightedPathsFromSource(N root, int depth) {
        int pathIdx = 1;
        for (Object e : this.graph.outEdges(root)) {
            this.pathIndices.put(e, pathIdx);
            this.roots.put(e, root);
            this.newNodeEncountered(pathIdx, this.graph.incidentNodes(e).target(), root);
            ++pathIdx;
        }
        ArrayList<E> edges = new ArrayList<E>();
        N virtualNode = this.nodeFactory.get();
        this.graph.addNode(virtualNode);
        E virtualSinkEdge = this.edgeFactory.get();
        this.graph.addEdge(virtualNode, root, virtualSinkEdge);
        edges.add(virtualSinkEdge);
        for (int currentDepth = 0; currentDepth <= depth; ++currentDepth) {
            double currentWeight = Math.pow(this.alpha, -1.0 * (double)currentDepth);
            for (Object currentEdge : edges) {
                this.incrementRankScore(this.graph.incidentNodes(currentEdge).target(), currentWeight);
            }
            if (currentDepth == depth || edges.size() == 0) break;
            ArrayList newEdges = new ArrayList();
            for (Object currentSourceEdge : edges) {
                Number sourcePathIndex = this.pathIndices.get(currentSourceEdge);
                Object newDestNode = this.graph.incidentNodes(currentSourceEdge).target();
                for (Object currentDestEdge : this.graph.outEdges(newDestNode)) {
                    N destEdgeRoot = this.roots.get(currentDestEdge);
                    Object destEdgeDest = this.graph.incidentNodes(currentDestEdge).target();
                    if (currentSourceEdge == virtualSinkEdge) {
                        newEdges.add(currentDestEdge);
                        continue;
                    }
                    if (destEdgeRoot == root || destEdgeDest == this.graph.incidentNodes(currentSourceEdge).source()) continue;
                    Set<Number> pathsSeen = this.pathsSeenMap.get(destEdgeDest);
                    if (pathsSeen == null) {
                        this.newNodeEncountered(sourcePathIndex.intValue(), destEdgeDest, root);
                    } else if (this.roots.get(destEdgeDest) != root) {
                        this.roots.put(destEdgeDest, root);
                        pathsSeen.clear();
                        pathsSeen.add(sourcePathIndex);
                    } else {
                        if (pathsSeen.contains(sourcePathIndex)) continue;
                        pathsSeen.add(sourcePathIndex);
                    }
                    this.pathIndices.put(currentDestEdge, sourcePathIndex);
                    this.roots.put(currentDestEdge, root);
                    newEdges.add(currentDestEdge);
                }
            }
            edges = newEdges;
        }
        this.graph.removeNode(virtualNode);
    }

    private void newNodeEncountered(int sourcePathIndex, N dest, N root) {
        HashSet<Integer> pathsSeen = new HashSet<Integer>();
        pathsSeen.add(sourcePathIndex);
        this.pathsSeenMap.put(dest, pathsSeen);
        this.roots.put(dest, root);
    }

    private void evaluate() {
        for (Object node : this.graph.nodes()) {
            this.nodeScores.put(node, 0.0);
        }
        for (Object v : this.priors) {
            this.computeWeightedPathsFromSource(v, this.maxDepth);
        }
        double runningTotal = 0.0;
        for (Object node : this.graph.nodes()) {
            runningTotal += this.nodeScores.get(node).doubleValue();
        }
        double total = runningTotal;
        for (Object node : this.graph.nodes()) {
            this.nodeScores.computeIfPresent(node, (n, value) -> value / total);
        }
    }

    @Override
    public Double getNodeScore(N v) {
        return this.nodeScores.get(v);
    }

    @Override
    public Map<N, Double> nodeScores() {
        return Collections.unmodifiableMap(this.nodeScores);
    }
}

