/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import edu.uci.ics.jung.algorithms.util.MapBinaryHeap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;

public class MinimumSpanningTree<N, E> {
    public static <N, E> Network<N, E> extractFrom(Network<N, E> graph, Function<? super E, Double> edgeWeights) {
        HashSet remainingNodes = new HashSet(graph.nodes());
        HashMap nodeData = new HashMap();
        for (Object node : remainingNodes) {
            nodeData.put(node, new NodeData());
        }
        MapBinaryHeap heap = new MapBinaryHeap((a, b) -> Double.compare(((NodeData)nodeData.get(a)).cost, ((NodeData)nodeData.get(b)).cost));
        heap.addAll(remainingNodes);
        MutableNetwork tree = NetworkBuilder.undirected().build();
        while (!remainingNodes.isEmpty()) {
            Object node = heap.poll();
            remainingNodes.remove(node);
            Object edge = ((NodeData)nodeData.get(node)).connection;
            if (edge == null) {
                tree.addNode(node);
            } else {
                tree.addEdge(graph.incidentNodes(edge).adjacentNode(node), node, edge);
            }
            for (Object adjacentNode : graph.adjacentNodes(node)) {
                if (!remainingNodes.contains(adjacentNode)) continue;
                NodeData adjacentNodeData = (NodeData)nodeData.get(adjacentNode);
                for (Object connectingEdge : graph.edgesConnecting(node, adjacentNode)) {
                    double connectingEdgeWeight = edgeWeights.apply(connectingEdge);
                    if (!(connectingEdgeWeight < adjacentNodeData.cost)) continue;
                    adjacentNodeData.update(connectingEdgeWeight, connectingEdge);
                    heap.update(adjacentNode);
                }
            }
        }
        return tree;
    }

    public static <N, V extends Number> ValueGraph<N, V> extractFrom(ValueGraph<N, V> graph) {
        HashSet remainingNodes = new HashSet(graph.nodes());
        HashMap nodeData = new HashMap();
        for (Object node : remainingNodes) {
            nodeData.put(node, new NodeData());
        }
        MapBinaryHeap heap = new MapBinaryHeap((a, b) -> Double.compare(((NodeData)nodeData.get(a)).cost, ((NodeData)nodeData.get(b)).cost));
        heap.addAll(remainingNodes);
        MutableValueGraph tree = ValueGraphBuilder.directed().build();
        while (!remainingNodes.isEmpty()) {
            Object node = heap.peek();
            remainingNodes.remove(node);
            Object connectedNode = ((NodeData)nodeData.get(node)).connection;
            if (connectedNode == null) {
                tree.addNode(node);
            } else {
                tree.putEdgeValue(node, connectedNode, graph.edgeValue(node, connectedNode).orElseThrow(() -> new IllegalStateException("unexpected exception caused by bug in graph data structures")));
            }
            for (Object adjacentNode : graph.adjacentNodes(node)) {
                if (!remainingNodes.contains(adjacentNode)) continue;
                NodeData adjacentNodeData = (NodeData)nodeData.get(adjacentNode);
                double connectingEdgeWeight = ((Number)graph.edgeValue(node, adjacentNode).orElseThrow(() -> new IllegalStateException("unexpected exception caused by bug in graph data structures"))).doubleValue();
                if (!(connectingEdgeWeight < adjacentNodeData.cost)) continue;
                adjacentNodeData.update(connectingEdgeWeight, node);
                heap.update(adjacentNode);
            }
        }
        return tree;
    }

    private static class NodeData<T> {
        private double cost = Double.POSITIVE_INFINITY;
        private T connection = null;

        private NodeData() {
        }

        private void update(double cost, T connection) {
            this.cost = cost;
            this.connection = connection;
        }
    }
}

