/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import edu.uci.ics.jung.layout.algorithms.IterativeLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIterativeLayoutAlgorithm<N>
implements IterativeLayoutAlgorithm<N> {
    private static final Logger log = LoggerFactory.getLogger(AbstractIterativeLayoutAlgorithm.class);
    protected LayoutModel<N> layoutModel;
    protected boolean shouldPreRelax = true;
    protected int preRelaxDurationMs = 500;
    protected Random random = new Random();

    public void setRandomSeed(long randomSeed) {
        this.random = new Random(randomSeed);
    }

    @Override
    public final boolean preRelax() {
        if (!this.shouldPreRelax) {
            return false;
        }
        long timeNow = System.currentTimeMillis();
        while (System.currentTimeMillis() - timeNow < (long)this.preRelaxDurationMs && !this.done()) {
            this.step();
        }
        return true;
    }

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        log.trace("visiting " + layoutModel);
        this.layoutModel = layoutModel;
    }
}

