/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.graph.util.TreeUtils;
import edu.uci.ics.jung.layout.algorithms.TreeLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.model.PolarPoint;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BalloonLayoutAlgorithm<N>
extends TreeLayoutAlgorithm<N> {
    private static final Logger log = LoggerFactory.getLogger(BalloonLayoutAlgorithm.class);
    protected LoadingCache<N, PolarPoint> polarLocations = CacheBuilder.newBuilder().build(new CacheLoader<N, PolarPoint>(){

        public PolarPoint load(N node) {
            return PolarPoint.ORIGIN;
        }
    });
    protected Map<N, Double> radii = new HashMap<N, Double>();

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        super.visit(layoutModel);
        if (log.isTraceEnabled()) {
            log.trace("visit {}", layoutModel);
        }
        super.visit(layoutModel);
        this.setRootPolars(layoutModel);
    }

    private void putRadialPointsInModel(LayoutModel<N> layoutModel) {
        for (Map.Entry entry : this.polarLocations.asMap().entrySet()) {
            PolarPoint polar = (PolarPoint)entry.getValue();
            layoutModel.set(entry.getKey(), this.getCartesian(layoutModel, entry.getKey()));
        }
    }

    protected void setRootPolars(LayoutModel<N> layoutModel) {
        Graph<N> graph = layoutModel.getGraph();
        ImmutableSet roots = TreeUtils.roots(graph);
        int width = layoutModel.getWidth();
        if (roots.size() == 1) {
            Object root = Iterables.getOnlyElement((Iterable)roots);
            this.setRootPolar(layoutModel, root);
            this.setPolars(layoutModel, graph.successors(root), this.getCenter(layoutModel), width / 2);
        } else if (roots.size() > 1) {
            this.setPolars(layoutModel, (Set<N>)roots, this.getCenter(layoutModel), width / 2);
        }
    }

    protected void setRootPolar(LayoutModel<N> layoutModel, N root) {
        PolarPoint pp = PolarPoint.ORIGIN;
        Point p = this.getCenter(layoutModel);
        this.polarLocations.put(root, (Object)pp);
        layoutModel.set(root, p);
    }

    protected void setPolars(LayoutModel<N> layoutModel, Set<N> kids, Point parentLocation, double parentRadius) {
        int childCount = kids.size();
        if (childCount == 0) {
            return;
        }
        double angle = Math.max(0.0, 1.5707963267948966 * (1.0 - 2.0 / (double)childCount));
        double childRadius = parentRadius * Math.cos(angle) / (1.0 + Math.cos(angle));
        double radius = parentRadius - childRadius;
        double rand = Math.random();
        int i = 0;
        for (N child : kids) {
            double theta = (double)(i++ * 2) * Math.PI / (double)childCount + rand;
            this.radii.put(child, childRadius);
            PolarPoint pp = PolarPoint.of(theta, radius);
            this.polarLocations.put(child, (Object)pp);
            Point p = PolarPoint.polarToCartesian(pp);
            p = p.add(parentLocation.x, parentLocation.y);
            layoutModel.set(child, p);
            this.setPolars(layoutModel, layoutModel.getGraph().successors(child), p, childRadius);
        }
    }

    public Point getCenter(LayoutModel<N> layoutModel, N node) {
        Graph<N> graph = layoutModel.getGraph();
        Object parent = Iterables.getOnlyElement((Iterable)graph.predecessors(node), null);
        if (parent == null) {
            return this.getCenter(layoutModel);
        }
        return layoutModel.get(parent);
    }

    private Point getCartesian(LayoutModel<N> layoutModel, N node) {
        PolarPoint pp = (PolarPoint)this.polarLocations.getUnchecked(node);
        double centerX = layoutModel.getWidth() / 2;
        double centerY = layoutModel.getHeight() / 2;
        Point cartesian = PolarPoint.polarToCartesian(pp);
        cartesian = cartesian.add(centerX, centerY);
        return cartesian;
    }

    @Override
    protected void setLocation(LayoutModel<N> layoutModel, N node, Point location) {
        Point c = this.getCenter(layoutModel, node);
        Point pv = location.add(-c.x, -c.y);
        PolarPoint newLocation = PolarPoint.cartesianToPolar(pv.x, pv.y);
        this.polarLocations.put(node, (Object)newLocation);
        Point center = this.getCenter(layoutModel, node);
        center = pv.add(center.x, center.y);
        layoutModel.set(node, pv);
    }

    public Map<N, Double> getRadii() {
        return this.radii;
    }
}

