/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.base.Preconditions;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleLayoutAlgorithm<N>
implements LayoutAlgorithm<N> {
    private static final Logger log = LoggerFactory.getLogger(CircleLayoutAlgorithm.class);
    private double radius;
    private List<N> node_ordered_list;

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public void setNodeOrder(LayoutModel<N> layoutModel, Comparator<N> comparator) {
        if (this.node_ordered_list == null) {
            this.node_ordered_list = new ArrayList<N>(layoutModel.getGraph().nodes());
        }
        Collections.sort(this.node_ordered_list, comparator);
    }

    public void setNodeOrder(LayoutModel<N> layoutModel, List<N> node_list) {
        Preconditions.checkArgument((boolean)node_list.containsAll(layoutModel.getGraph().nodes()), (Object)"Supplied list must include all nodes of the graph");
        this.node_ordered_list = node_list;
    }

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        if (layoutModel != null) {
            this.setNodeOrder(layoutModel, new ArrayList(layoutModel.getGraph().nodes()));
            double height = layoutModel.getHeight();
            double width = layoutModel.getWidth();
            if (this.radius <= 0.0) {
                this.radius = 0.45 * (height < width ? height : width);
            }
            int i = 0;
            for (N node : this.node_ordered_list) {
                double angle = Math.PI * 2 * (double)i / (double)this.node_ordered_list.size();
                double posX = Math.cos(angle) * this.radius + width / 2.0;
                double posY = Math.sin(angle) * this.radius + height / 2.0;
                layoutModel.set(node, posX, posY);
                log.trace("set {} to {},{} ", new Object[]{node, posX, posY});
                ++i;
            }
        }
    }
}

