/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.layout.algorithms.SpringLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGLayoutAlgorithm<N>
extends SpringLayoutAlgorithm<N> {
    private static final Logger log = LoggerFactory.getLogger(DAGLayoutAlgorithm.class);
    private Map<N, Number> minLevels = new HashMap<N, Number>();
    static int graphHeight;
    static int numRoots;
    final double SPACEFACTOR = 1.3;
    final double LEVELATTRACTIONRATE = 0.8;
    final double MSV_THRESHOLD = 10.0;
    double meanSquareVel;
    boolean stoppingIncrements = false;
    int incrementsLeft;
    final int COOL_DOWN_INCREMENTS = 200;

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        super.visit(layoutModel);
        this.initialize();
    }

    public void setRoot() {
        Graph graph = this.layoutModel.getGraph();
        numRoots = 0;
        for (Object node : graph.nodes()) {
            if (!graph.successors(node).isEmpty()) continue;
            this.setRoot(node);
            ++numRoots;
        }
    }

    public void setRoot(N node) {
        this.minLevels.put(node, new Integer(0));
        this.propagateMinimumLevel(node);
    }

    public void propagateMinimumLevel(N node) {
        Graph graph = this.layoutModel.getGraph();
        int level = this.minLevels.get(node).intValue();
        for (Object child : graph.predecessors(node)) {
            Number o = this.minLevels.get(child);
            int oldLevel = o != null ? o.intValue() : 0;
            int newLevel = Math.max(oldLevel, level + 1);
            this.minLevels.put(child, new Integer(newLevel));
            if (newLevel > graphHeight) {
                graphHeight = newLevel;
            }
            this.propagateMinimumLevel(child);
        }
    }

    private void initializeLocation(N node, Point coord, int width, int height) {
        int level = this.minLevels.get(node).intValue();
        int minY = (int)((double)(level * height) / ((double)graphHeight * 1.3));
        double x = Math.random() * (double)width;
        double y = Math.random() * (double)(height - minY) + (double)minY;
        this.layoutModel.set(node, x, y);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.setRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void moveNodes() {
        int width = this.layoutModel.getWidth();
        int height = this.layoutModel.getHeight();
        Graph graph = this.layoutModel.getGraph();
        double oldMSV = this.meanSquareVel;
        this.meanSquareVel = 0.0;
        LayoutModel layoutModel = this.layoutModel;
        synchronized (layoutModel) {
            for (Object node : graph.nodes()) {
                if (this.layoutModel.isLocked(node)) continue;
                SpringLayoutAlgorithm.SpringNodeData vd = (SpringLayoutAlgorithm.SpringNodeData)this.springNodeData.getUnchecked(node);
                Point xyd = (Point)this.layoutModel.apply(node);
                int level = this.minLevels.get(node).intValue();
                int minY = (int)((double)(level * height) / ((double)graphHeight * 1.3));
                int maxY = level == 0 ? (int)((double)height / ((double)graphHeight * 1.3 * 2.0)) : height;
                vd.dx += 2.0 * vd.repulsiondx + vd.edgedx;
                vd.dy += vd.repulsiondy + vd.edgedy;
                double delta = xyd.y - (double)minY;
                vd.dy -= delta * 0.8;
                if (level == 0) {
                    vd.dy -= delta * 0.8;
                }
                this.meanSquareVel += vd.dx * vd.dx + vd.dy * vd.dy;
                double posX = xyd.x + Math.max(-5.0, Math.min(5.0, vd.dx));
                double posY = xyd.y + Math.max(-5.0, Math.min(5.0, vd.dy));
                if (posX < 0.0) {
                    posX = 0.0;
                } else if (posX > (double)width) {
                    posX = width;
                }
                if (posY < 0.0) {
                    posY = 0.0;
                } else if (posY > (double)height) {
                    posY = height;
                }
                if (numRoots == 1 && level == 0) {
                    posX = width / 2;
                }
                this.setLocation(node, posX, posY);
            }
        }
        if (!this.stoppingIncrements && Math.abs(this.meanSquareVel - oldMSV) < 10.0) {
            this.stoppingIncrements = true;
            this.incrementsLeft = 200;
        } else if (this.stoppingIncrements && Math.abs(this.meanSquareVel - oldMSV) <= 10.0) {
            --this.incrementsLeft;
            if (this.incrementsLeft <= 0) {
                this.incrementsLeft = 0;
            }
        }
    }

    @Override
    public boolean done() {
        return this.stoppingIncrements && this.incrementsLeft == 0;
    }

    public void setLocation(N picked, double x, double y) {
        Point coord = (Point)this.layoutModel.apply(picked);
        this.layoutModel.set(picked, coord);
        this.stoppingIncrements = false;
    }

    public void setLocation(N picked, Point p) {
        this.setLocation(picked, p.x, p.y);
    }

    @Override
    protected void relaxEdges() {
        Graph graph = this.layoutModel.getGraph();
        for (EndpointPair endpoints : graph.edges()) {
            Object node1 = endpoints.nodeU();
            Object node2 = endpoints.nodeV();
            Point p1 = (Point)this.layoutModel.apply(node1);
            Point p2 = (Point)this.layoutModel.apply(node2);
            double vx = p1.x - p2.x;
            double vy = p1.y - p2.y;
            double len = Math.sqrt(vx * vx + vy * vy);
            int level1 = this.minLevels.get(node1).intValue();
            int level2 = this.minLevels.get(node2).intValue();
            double desiredLen = ((Integer)this.lengthFunction.apply(endpoints)).intValue();
            len = len == 0.0 ? 1.0E-4 : len;
            double f = this.force_multiplier * (desiredLen - len) / len;
            f *= Math.pow(this.stretch / 100.0, graph.degree(node1) + graph.degree(node2) - 2);
            if (level1 != level2) {
                f /= Math.pow(Math.abs(level2 - level1), 1.5);
            }
            double dx = f * vx;
            double dy = f * vy;
            SpringLayoutAlgorithm.SpringNodeData v1D = (SpringLayoutAlgorithm.SpringNodeData)this.springNodeData.getUnchecked(node1);
            SpringLayoutAlgorithm.SpringNodeData v2D = (SpringLayoutAlgorithm.SpringNodeData)this.springNodeData.getUnchecked(node2);
            v1D.edgedx += dx;
            v1D.edgedy += dy;
            v2D.edgedx += -dx;
            v2D.edgedy += -dy;
        }
    }
}

