/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import edu.uci.ics.jung.layout.algorithms.TreeLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.model.PolarPoint;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RadialTreeLayoutAlgorithm<N>
extends TreeLayoutAlgorithm<N> {
    private static final Logger log = LoggerFactory.getLogger(RadialTreeLayoutAlgorithm.class);
    protected Map<N, PolarPoint> polarLocations = new HashMap<N, PolarPoint>();

    public RadialTreeLayoutAlgorithm() {
        this(DEFAULT_DISTX, DEFAULT_DISTY);
    }

    public RadialTreeLayoutAlgorithm(int distx) {
        this(distx, DEFAULT_DISTY);
    }

    public RadialTreeLayoutAlgorithm(int distx, int disty) {
        super(distx, disty);
    }

    @Override
    protected void buildTree(LayoutModel<N> layoutModel) {
        super.buildTree(layoutModel);
        this.setRadialLocations(layoutModel);
        this.putRadialPointsInModel(layoutModel);
    }

    private void putRadialPointsInModel(LayoutModel<N> layoutModel) {
        for (Map.Entry<N, PolarPoint> entry : this.polarLocations.entrySet()) {
            PolarPoint polar = entry.getValue();
            layoutModel.set(entry.getKey(), this.getCartesian(layoutModel, entry.getKey()));
        }
    }

    @Override
    protected void setLocation(LayoutModel<N> layoutModel, N node, Point location) {
        Point c = this.getCenter(layoutModel);
        Point pv = location.add(-c.x, -c.y);
        PolarPoint newLocation = PolarPoint.cartesianToPolar(pv);
        PolarPoint currentLocation = this.polarLocations.get(node);
        if (currentLocation == null) {
            this.polarLocations.put(node, newLocation);
        } else {
            this.polarLocations.put(node, newLocation);
        }
    }

    public Map<N, PolarPoint> getPolarLocations() {
        return this.polarLocations;
    }

    private Point getCartesian(LayoutModel<N> layoutModel, N node) {
        PolarPoint pp = this.polarLocations.get(node);
        double centerX = layoutModel.getWidth() / 2;
        double centerY = layoutModel.getHeight() / 2;
        Point cartesian = PolarPoint.polarToCartesian(pp);
        cartesian = cartesian.add(centerX, centerY);
        return cartesian;
    }

    private Point getMaxXY(LayoutModel<N> layoutModel) {
        double maxx = 0.0;
        double maxy = 0.0;
        Set nodes = layoutModel.getGraph().nodes();
        for (Object node : nodes) {
            Point location = (Point)layoutModel.apply(node);
            maxx = Math.max(maxx, location.x);
            maxy = Math.max(maxy, location.y);
        }
        return Point.of(maxx, maxy);
    }

    private void setRadialLocations(LayoutModel<N> layoutModel) {
        int width = layoutModel.getWidth();
        Point max = this.getMaxXY(layoutModel);
        double maxx = max.x;
        double maxy = max.y;
        maxx = Math.max(maxx, (double)width);
        double theta = Math.PI * 2 / maxx;
        double deltaRadius = (double)(width / 2) / maxy;
        for (Object node : layoutModel.getGraph().nodes()) {
            Point p = layoutModel.get(node);
            PolarPoint polarPoint = PolarPoint.of(p.x * theta, (p.y - (double)this.distY) * deltaRadius);
            this.polarLocations.put(node, polarPoint);
        }
    }
}

