/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.model;

import com.google.common.collect.Lists;
import edu.uci.ics.jung.layout.model.LayoutModel;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLayoutModelChangeSupport
implements LayoutModel.ChangeSupport {
    private static final Logger log = LoggerFactory.getLogger(DefaultLayoutModelChangeSupport.class);
    protected boolean fireEvents = true;
    protected List<LayoutModel.ChangeListener> changeListeners = Collections.synchronizedList(Lists.newArrayList());

    @Override
    public boolean isFireEvents() {
        return this.fireEvents;
    }

    @Override
    public void setFireEvents(boolean fireEvents) {
        log.trace("setFireEvents {}", (Object)fireEvents);
        this.fireEvents = fireEvents;
        if (fireEvents) {
            this.fireChanged();
        }
    }

    @Override
    public void addChangeListener(LayoutModel.ChangeListener l) {
        this.changeListeners.add(l);
    }

    @Override
    public void removeChangeListener(LayoutModel.ChangeListener l) {
        this.changeListeners.remove(l);
    }

    @Override
    public void fireChanged() {
        if (this.fireEvents && !this.changeListeners.isEmpty()) {
            for (LayoutModel.ChangeListener listener : this.changeListeners) {
                listener.changed();
            }
        }
    }

    public List<LayoutModel.ChangeListener> getChangeListeners() {
        return this.changeListeners;
    }
}

