/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.spatial;

import com.google.common.base.Preconditions;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.spatial.ForceObject;
import edu.uci.ics.jung.layout.spatial.Node;
import edu.uci.ics.jung.layout.spatial.Rectangle;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BarnesHutQuadTree<T> {
    private static final Logger log = LoggerFactory.getLogger(BarnesHutQuadTree.class);
    private Node<T> root;
    private Object lock = new Object();

    public Rectangle getBounds() {
        return this.root.getBounds();
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public BarnesHutQuadTree(double width, double height) {
        this.root = new Node(new Rectangle(0.0, 0.0, width, height));
    }

    public BarnesHutQuadTree(Rectangle r) {
        this.root = new Node(r);
    }

    public void clear() {
        this.root.clear();
    }

    public void applyForcesTo(ForceObject<T> visitor) {
        Preconditions.checkArgument((visitor != null ? 1 : 0) != 0, (Object)"Cannot apply forces to a null ForceObject");
        if (this.root != null && this.root.forceObject != visitor) {
            this.root.applyForcesTo(visitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insert(ForceObject node) {
        Object object = this.lock;
        synchronized (object) {
            this.root.insert(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuild(Map<T, Point> locations) {
        this.clear();
        Object object = this.lock;
        synchronized (object) {
            for (Map.Entry<T, Point> entry : locations.entrySet()) {
                ForceObject<T> forceObject = new ForceObject<T>(entry.getKey(), entry.getValue());
                this.insert(forceObject);
            }
        }
    }

    public String toString() {
        return "Tree:" + this.root;
    }
}

