/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.spatial;

import com.google.common.base.Preconditions;
import edu.uci.ics.jung.layout.model.Point;

public class Rectangle {
    public final double x;
    public final double y;
    public final double width;
    public final double height;
    public final double maxX;
    public final double maxY;

    public Rectangle(double x, double y, double width, double height) {
        Preconditions.checkArgument((width >= 0.0 && height >= 0.0 ? 1 : 0) != 0, (Object)"width and height must be non-negative");
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.maxX = x + width;
        this.maxY = y + height;
    }

    public double getCenterX() {
        return this.x + this.width / 2.0;
    }

    public double getCenterY() {
        return this.y + this.height / 2.0;
    }

    public boolean intersects(Rectangle other) {
        return this.maxX >= other.x && other.maxX >= this.x && this.maxY >= other.y && other.maxY >= this.y;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(double ox, double oy) {
        return ox >= this.x && ox <= this.maxX && oy >= this.y && oy <= this.maxY;
    }
}

