/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.util;

import edu.uci.ics.jung.layout.model.Point;
import java.util.Date;
import java.util.Random;
import java.util.function.Function;

public class RandomLocationTransformer<N>
implements Function<N, Point> {
    protected double width;
    protected double height;
    protected double depth;
    protected Random random;
    protected Origin origin = Origin.NE;

    public RandomLocationTransformer(double width, double height) {
        this(Origin.NE, width, height, new Date().getTime());
    }

    public RandomLocationTransformer(Origin origin, double width, double height) {
        this(origin, width, height, new Date().getTime());
    }

    public RandomLocationTransformer(double width, double height, long seed) {
        this(Origin.NE, width, height, seed);
    }

    public RandomLocationTransformer(Origin origin, double width, double height, long seed) {
        this.origin = origin;
        this.width = width;
        this.height = height;
        this.random = new Random(seed);
    }

    private Point applyNE(N node) {
        return Point.of(this.random.nextDouble() * this.width, this.random.nextDouble() * this.height);
    }

    private Point applyCenter(N node) {
        double radiusX = this.width / 2.0;
        double radiusY = this.height / 2.0;
        return Point.of(this.random.nextDouble() * this.width - radiusX, this.random.nextDouble() * this.height - radiusY);
    }

    @Override
    public Point apply(N node) {
        if (this.origin == Origin.NE) {
            return this.applyNE(node);
        }
        return this.applyCenter(node);
    }

    public static enum Origin {
        NE,
        CENTER;

    }
}

