/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import com.google.common.graph.Network;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;

public class WeakComponentClusterer<N, E>
implements Function<Network<N, E>, Set<Set<N>>> {
    @Override
    public Set<Set<N>> apply(Network<N, E> graph) {
        HashSet<Set<N>> clusterSet = new HashSet<Set<N>>();
        HashSet unvisitedNodes = new HashSet(graph.nodes());
        while (!unvisitedNodes.isEmpty()) {
            HashSet cluster = new HashSet();
            Object root = unvisitedNodes.iterator().next();
            unvisitedNodes.remove(root);
            cluster.add(root);
            LinkedList queue = new LinkedList();
            queue.add(root);
            while (!queue.isEmpty()) {
                Object currentNode = queue.remove();
                Set neighbors = graph.adjacentNodes(currentNode);
                for (Object neighbor : neighbors) {
                    if (!unvisitedNodes.contains(neighbor)) continue;
                    queue.add(neighbor);
                    unvisitedNodes.remove(neighbor);
                    cluster.add(neighbor);
                }
            }
            clusterSet.add(cluster);
        }
        return clusterSet;
    }
}

