/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayDeque;
import java.util.Set;

public class KNeighborhoodFilter {
    public static <N> MutableGraph<N> filterGraph(Graph<N> graph, Set<N> rootNodes, int radius) {
        Preconditions.checkNotNull(graph);
        Preconditions.checkNotNull(rootNodes);
        Preconditions.checkArgument((boolean)graph.nodes().containsAll(rootNodes), (Object)"graph must contain all of rootNodes");
        Preconditions.checkArgument((radius > 0 ? 1 : 0) != 0, (Object)"radius must be > 0");
        MutableGraph filtered = GraphBuilder.from(graph).build();
        for (N root : rootNodes) {
            filtered.addNode(root);
        }
        ArrayDeque<Object> currentNodes = new ArrayDeque<N>(rootNodes);
        ArrayDeque<Object> nextNodes = new ArrayDeque();
        for (int depth = 1; depth <= radius && !currentNodes.isEmpty(); ++depth) {
            while (!currentNodes.isEmpty()) {
                Object currentNode = currentNodes.remove();
                for (Object nextNode : graph.successors(currentNode)) {
                    if (filtered.addNode(nextNode)) {
                        nextNodes.add(nextNode);
                    }
                    filtered.putEdge(currentNode, nextNode);
                }
            }
            ArrayDeque<N> emptyQueue = currentNodes;
            currentNodes = nextNodes;
            nextNodes = emptyQueue;
        }
        for (Object node : filtered.nodes()) {
            for (Object predecessor : graph.predecessors(node)) {
                if (!filtered.nodes().contains(predecessor)) continue;
                filtered.putEdge(predecessor, node);
            }
        }
        return filtered;
    }
}

