/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class Lattice2DGenerator<N, E> {
    private final int rowCount;
    private final int colCount;
    private final boolean toroidal;

    public Lattice2DGenerator(int rowCount, int colCount, boolean toroidal) {
        Preconditions.checkArgument((rowCount >= 4 ? 1 : 0) != 0, (Object)"row count must be >= 4");
        Preconditions.checkArgument((colCount >= 4 ? 1 : 0) != 0, (Object)"column count must be >= 4");
        this.rowCount = rowCount;
        this.colCount = colCount;
        this.toroidal = toroidal;
    }

    public MutableNetwork<N, E> generateNetwork(boolean directed, Supplier<N> nodeFactory, Supplier<E> edgeFactory) {
        int j;
        int i;
        Preconditions.checkNotNull(nodeFactory);
        Preconditions.checkNotNull(edgeFactory);
        int node_count = this.rowCount * this.colCount;
        int boundary_adjustment = this.toroidal ? 0 : 1;
        int edge_count = this.colCount * (this.rowCount - boundary_adjustment) + this.rowCount * (this.colCount - boundary_adjustment);
        if (directed) {
            edge_count *= 2;
        }
        NetworkBuilder builder = directed ? NetworkBuilder.directed() : NetworkBuilder.undirected();
        MutableNetwork graph = builder.expectedNodeCount(node_count).expectedEdgeCount(edge_count).build();
        for (int i2 = 0; i2 < node_count; ++i2) {
            N v = nodeFactory.get();
            graph.addNode(v);
        }
        ArrayList elements = new ArrayList(graph.nodes());
        int end_row = this.toroidal ? this.rowCount : this.rowCount - 1;
        int end_col = this.toroidal ? this.colCount : this.colCount - 1;
        for (i = 0; i < end_row; ++i) {
            for (j = 0; j < this.colCount; ++j) {
                graph.addEdge(elements.get(this.getIndex(i, j)), elements.get(this.getIndex(i + 1, j)), edgeFactory.get());
            }
        }
        for (i = 0; i < this.rowCount; ++i) {
            for (j = 0; j < end_col; ++j) {
                graph.addEdge(elements.get(this.getIndex(i, j)), elements.get(this.getIndex(i, j + 1)), edgeFactory.get());
            }
        }
        if (graph.isDirected()) {
            Set endpointPairs = graph.edges().stream().map(arg_0 -> ((MutableNetwork)graph).incidentNodes(arg_0)).collect(Collectors.toSet());
            for (EndpointPair endpoints : endpointPairs) {
                graph.addEdge(endpoints.target(), endpoints.source(), edgeFactory.get());
            }
        }
        return graph;
    }

    public Distance<N> distance(Graph<N> graph) {
        return new LatticeDistance(graph);
    }

    int getIndex(int i, int j) {
        return this.mod(i, this.rowCount) * this.colCount + this.mod(j, this.colCount);
    }

    private int mod(int i, int modulus) {
        int i_mod = i % modulus;
        return i_mod >= 0 ? i_mod : i_mod + modulus;
    }

    private class LatticeDistance
    implements Distance<N> {
        private final Map<N, Integer> nodeIndices = new HashMap();
        private final LoadingCache<N, LoadingCache<N, Number>> distances = CacheBuilder.newBuilder().build(new CacheLoader<N, LoadingCache<N, Number>>(){

            public LoadingCache<N, Number> load(final N source) {
                return CacheBuilder.newBuilder().build(new CacheLoader<N, Number>(){

                    public Number load(N target) {
                        return LatticeDistance.this.getDistance(source, target);
                    }
                });
            }
        });

        private LatticeDistance(Graph<N> graph) {
            Preconditions.checkNotNull(graph);
            int index = 0;
            for (Object node : graph.nodes()) {
                this.nodeIndices.put(node, index++);
            }
        }

        @Override
        public Number getDistance(N source, N target) {
            int sourceIndex = this.nodeIndices.get(source);
            int targetIndex = this.nodeIndices.get(target);
            int sourceRow = this.getRow(sourceIndex);
            int sourceCol = this.getCol(sourceIndex);
            int targetRow = this.getRow(targetIndex);
            int targetCol = this.getCol(targetIndex);
            int v_dist = Math.abs(sourceRow - targetRow);
            int h_dist = Math.abs(sourceCol - targetCol);
            if (Lattice2DGenerator.this.toroidal) {
                v_dist = Math.min(v_dist, Math.abs(Lattice2DGenerator.this.rowCount - v_dist) + 1);
                h_dist = Math.min(h_dist, Math.abs(Lattice2DGenerator.this.colCount - h_dist) + 1);
            }
            return v_dist + h_dist;
        }

        @Override
        public Map<N, ? extends Number> getDistanceMap(N source) {
            return ((LoadingCache)this.distances.getUnchecked(source)).asMap();
        }

        private int getRow(int i) {
            return i / Lattice2DGenerator.this.colCount;
        }

        private int getCol(int i) {
            return i % Lattice2DGenerator.this.colCount;
        }
    }
}

