/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.util.ArrayList;
import java.util.Random;
import java.util.function.Supplier;

public class ErdosRenyiGenerator<N> {
    private int nodeCount;
    private double edgeConnectionProbability;
    private Random random;
    Supplier<N> nodeSupplier;

    public ErdosRenyiGenerator(Supplier<N> nodeSupplier, int nodeCount, double p) {
        this.nodeSupplier = (Supplier)Preconditions.checkNotNull(nodeSupplier);
        Preconditions.checkArgument((nodeCount > 0 ? 1 : 0) != 0, (Object)"Number of nodes must be positive");
        Preconditions.checkArgument((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (Object)"Probability of connection must be in [0, 1]");
        this.nodeCount = nodeCount;
        this.edgeConnectionProbability = p;
        this.random = new Random();
    }

    public Graph<N> get() {
        MutableGraph graph = GraphBuilder.undirected().expectedNodeCount(this.nodeCount).build();
        for (int i = 0; i < this.nodeCount; ++i) {
            graph.addNode(this.nodeSupplier.get());
        }
        ArrayList list = new ArrayList(graph.nodes());
        for (int i = 0; i < this.nodeCount - 1; ++i) {
            Object v_i = list.get(i);
            for (int j = i + 1; j < this.nodeCount; ++j) {
                Object v_j = list.get(j);
                if (!(this.random.nextDouble() < this.edgeConnectionProbability)) continue;
                graph.putEdge(v_i, v_j);
            }
        }
        return graph;
    }

    public void setRandom(Random random) {
        this.random = random;
    }
}

