/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.scoring.HITSWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import java.util.function.Function;

public class HITS<N, E>
extends HITSWithPriors<N, E> {
    public HITS(Network<N, E> g, Function<E, Double> edge_weights, double alpha) {
        super(g, edge_weights, ScoringUtils.getHITSUniformRootPrior(g.nodes()), alpha);
    }

    public HITS(Network<N, E> g, double alpha) {
        super(g, ScoringUtils.getHITSUniformRootPrior(g.nodes()), alpha);
    }

    public HITS(Network<N, E> g) {
        this(g, 0.0);
    }

    public static class Scores {
        public double hub;
        public double authority;

        public Scores(double hub, double authority) {
            this.hub = hub;
            this.authority = authority;
        }

        public String toString() {
            return String.format("[h:%.4f,a:%.4f]", this.hub, this.authority);
        }
    }
}

