/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Preconditions;
import com.google.common.graph.Graph;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BFSDistanceLabeler<N> {
    private Map<N, Integer> distanceDecorator = new HashMap<N, Integer>();
    private List<N> mCurrentList;
    private Set<N> mUnvisitedNodes;
    private List<N> mNodesInOrderVisited;
    private Map<N, HashSet<N>> mPredecessorMap = new HashMap<N, HashSet<N>>();

    public List<N> getNodesInOrderVisited() {
        return this.mNodesInOrderVisited;
    }

    public Set<N> getUnvisitedNodes() {
        return this.mUnvisitedNodes;
    }

    public int getDistance(Graph<N> g, N v) {
        Preconditions.checkArgument((boolean)g.nodes().contains(v), (String)"Node %s is not contained in the graph %s", v, g);
        return this.distanceDecorator.get(v);
    }

    public Set<N> getPredecessors(N v) {
        return this.mPredecessorMap.get(v);
    }

    protected void initialize(Graph<N> g, Set<N> rootSet) {
        this.mNodesInOrderVisited = new ArrayList<N>();
        this.mUnvisitedNodes = new HashSet<N>();
        for (Object currentNode : g.nodes()) {
            this.mUnvisitedNodes.add(currentNode);
            this.mPredecessorMap.put(currentNode, new HashSet());
        }
        this.mCurrentList = new ArrayList<N>();
        for (Object v : rootSet) {
            this.distanceDecorator.put(v, 0);
            this.mCurrentList.add(v);
            this.mUnvisitedNodes.remove(v);
            this.mNodesInOrderVisited.add(v);
        }
    }

    private void addPredecessor(N predecessor, N successor) {
        HashSet<N> predecessors = this.mPredecessorMap.get(successor);
        predecessors.add(predecessor);
    }

    public void labelDistances(Graph<N> graph, Set<N> rootSet) {
        this.initialize(graph, rootSet);
        int distance = 1;
        while (true) {
            ArrayList<N> newList = new ArrayList<N>();
            for (N currentNode : this.mCurrentList) {
                if (!graph.nodes().contains(currentNode)) continue;
                for (Object next : graph.successors(currentNode)) {
                    this.visitNewNode(currentNode, next, distance, newList);
                }
            }
            if (newList.size() == 0) break;
            this.mCurrentList = newList;
            ++distance;
        }
        for (N v : this.mUnvisitedNodes) {
            this.distanceDecorator.put(v, -1);
        }
    }

    public void labelDistances(Graph<N> graph, N root) {
        this.labelDistances(graph, (N)Collections.singleton(root));
    }

    private void visitNewNode(N predecessor, N neighbor, int distance, List<N> newList) {
        int successorDistance;
        int predecessorDistance;
        if (this.mUnvisitedNodes.contains(neighbor)) {
            this.distanceDecorator.put(neighbor, distance);
            newList.add(neighbor);
            this.mNodesInOrderVisited.add(neighbor);
            this.mUnvisitedNodes.remove(neighbor);
        }
        if ((predecessorDistance = this.distanceDecorator.get(predecessor).intValue()) < (successorDistance = this.distanceDecorator.get(neighbor).intValue())) {
            this.addPredecessor(predecessor, neighbor);
        }
    }

    public Map<N, Integer> getDistanceDecorator() {
        return this.distanceDecorator;
    }
}

