/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.graph.Network;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ShortestPathUtils {
    public static <N, E> List<E> getPath(Network<N, E> graph, ShortestPath<N, E> sp, N source, N target) {
        LinkedList<E> path = new LinkedList<E>();
        Map<N, E> incomingEdges = sp.getIncomingEdgeMap(source);
        if (incomingEdges.isEmpty() || incomingEdges.get(target) == null) {
            return path;
        }
        Object current = target;
        while (!current.equals(source)) {
            E incoming = incomingEdges.get(current);
            path.addFirst(incoming);
            current = graph.incidentNodes(incoming).adjacentNode(current);
        }
        return path;
    }
}

