/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.graph.Graph;
import edu.uci.ics.jung.algorithms.shortestpath.BFSDistanceLabeler;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import java.util.HashMap;
import java.util.Map;

public class UnweightedShortestPath<N>
implements Distance<N> {
    private Map<N, Map<N, Integer>> mDistanceMap;
    private Map<N, Map<N, N>> mPredecessorMap;
    private Graph<N> mGraph;
    private Map<N, Integer> distances = new HashMap<N, Integer>();

    public UnweightedShortestPath(Graph<N> g) {
        this.mDistanceMap = new HashMap<N, Map<N, Integer>>();
        this.mPredecessorMap = new HashMap<N, Map<N, N>>();
        this.mGraph = g;
    }

    @Override
    public Integer getDistance(N source, N target) {
        Map<N, Integer> sourceSPMap = this.getDistanceMap(source);
        return sourceSPMap.get(target);
    }

    @Override
    public Map<N, Integer> getDistanceMap(N source) {
        Map<N, Integer> sourceSPMap = this.mDistanceMap.get(source);
        if (sourceSPMap == null) {
            this.computeShortestPathsFromSource(source);
            sourceSPMap = this.mDistanceMap.get(source);
        }
        return sourceSPMap;
    }

    public Map<N, N> getIncomingEdgeMap(N source) {
        Map<N, N> sourceIEMap = this.mPredecessorMap.get(source);
        if (sourceIEMap == null) {
            this.computeShortestPathsFromSource(source);
            sourceIEMap = this.mPredecessorMap.get(source);
        }
        return sourceIEMap;
    }

    private void computeShortestPathsFromSource(N source) {
        BFSDistanceLabeler<N> labeler = new BFSDistanceLabeler<N>();
        labeler.labelDistances(this.mGraph, source);
        this.distances = labeler.getDistanceDecorator();
        HashMap currentSourceSPMap = new HashMap();
        HashMap currentSourcePredMap = new HashMap();
        for (Object node : this.mGraph.nodes()) {
            Integer distanceVal = this.distances.get(node);
            if (distanceVal == null || distanceVal < 0) continue;
            currentSourceSPMap.put(node, distanceVal);
            int minDistance = distanceVal;
            for (Object predecessor : this.mGraph.predecessors(node)) {
                Integer predDistance;
                if (predecessor.equals(node) || (predDistance = this.distances.get(predecessor)) >= minDistance || predDistance < 0) continue;
                minDistance = predDistance;
                currentSourcePredMap.put(node, predecessor);
            }
        }
        this.mDistanceMap.put(source, currentSourceSPMap);
        this.mPredecessorMap.put(source, currentSourcePredMap);
    }

    public void reset() {
        this.mDistanceMap.clear();
        this.mPredecessorMap.clear();
    }

    public void reset(N v) {
        this.mDistanceMap.remove(v);
        this.mPredecessorMap.remove(v);
    }
}

