/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import com.google.common.base.Preconditions;
import edu.uci.ics.jung.algorithms.util.IterativeContext;

public abstract class IterativeProcess
implements IterativeContext {
    private int iterations;
    private int maximumIterations = 50;
    private double desiredPrecision = Double.MIN_VALUE;
    private double precision;

    public void evaluate() {
        this.iterations = 0;
        this.initializeIterations();
        while (this.iterations++ < this.maximumIterations) {
            this.step();
            this.precision = this.getPrecision();
            if (!this.hasConverged()) continue;
        }
        this.finalizeIterations();
    }

    @Override
    public abstract void step();

    protected void finalizeIterations() {
    }

    public double getDesiredPrecision() {
        return this.desiredPrecision;
    }

    public int getIterations() {
        return this.iterations;
    }

    public int getMaximumIterations() {
        return this.maximumIterations;
    }

    public double getPrecision() {
        return this.precision;
    }

    public void setPrecision(double precision) {
        this.precision = precision;
    }

    public boolean hasConverged() {
        return this.precision < this.desiredPrecision;
    }

    @Override
    public boolean done() {
        return this.hasConverged();
    }

    protected void initializeIterations() {
    }

    public void reset() {
    }

    public double relativePrecision(double epsilon, double x) {
        return x > this.desiredPrecision ? epsilon / x : epsilon;
    }

    public void setDesiredPrecision(double prec) throws IllegalArgumentException {
        Preconditions.checkArgument((prec > 0.0 ? 1 : 0) != 0, (Object)"precision must be positive");
        this.desiredPrecision = prec;
    }

    public void setMaximumIterations(int maxIter) throws IllegalArgumentException {
        Preconditions.checkArgument((maxIter >= 1 ? 1 : 0) != 0, (Object)"max iterations must be >= 1");
        this.maximumIterations = maxIter;
    }
}

