/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import com.google.common.base.Preconditions;
import com.google.common.math.Stats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class KMeansClusterer<T> {
    protected int max_iterations;
    protected double convergence_threshold;
    protected Random rand;

    public KMeansClusterer(int max_iterations, double convergence_threshold) {
        this.max_iterations = max_iterations;
        this.convergence_threshold = convergence_threshold;
        this.rand = new Random();
    }

    public KMeansClusterer() {
        this(100, 0.001);
    }

    public int getMaxIterations() {
        return this.max_iterations;
    }

    public void setMaxIterations(int max_iterations) {
        Preconditions.checkArgument((max_iterations >= 0 ? 1 : 0) != 0, (Object)"max iterations must be >= 0");
        this.max_iterations = max_iterations;
    }

    public double getConvergenceThreshold() {
        return this.convergence_threshold;
    }

    public void setConvergenceThreshold(double convergence_threshold) {
        Preconditions.checkArgument((convergence_threshold > 0.0 ? 1 : 0) != 0, (Object)"convergence threshold must be > 0");
        this.convergence_threshold = convergence_threshold;
    }

    public Collection<Map<T, double[]>> cluster(Map<T, double[]> object_locations, int num_clusters) {
        Preconditions.checkNotNull(object_locations);
        Preconditions.checkArgument((!object_locations.isEmpty() ? 1 : 0) != 0, (Object)"'objects' must be non-empty");
        Preconditions.checkArgument((num_clusters >= 2 && num_clusters <= object_locations.size() ? 1 : 0) != 0, (Object)"number of clusters must be >= 2 and <= number of objects");
        HashSet<double[]> centroids = new HashSet<double[]>();
        Object[] obj_array = object_locations.keySet().toArray();
        HashSet<Object> tried = new HashSet<Object>();
        while (centroids.size() < num_clusters && tried.size() < object_locations.size()) {
            Object o = obj_array[(int)(this.rand.nextDouble() * (double)obj_array.length)];
            tried.add(o);
            double[] mean_value = object_locations.get(o);
            boolean duplicate = false;
            for (double[] cur : centroids) {
                if (!Arrays.equals(mean_value, cur)) continue;
                duplicate = true;
            }
            if (duplicate) continue;
            centroids.add(mean_value);
        }
        if (tried.size() >= object_locations.size()) {
            throw new NotEnoughClustersException();
        }
        Map<double[], Map<T, double[]>> clusterMap = this.assignToClusters(object_locations, centroids);
        int iterations = 0;
        double max_movement = Double.POSITIVE_INFINITY;
        while (iterations++ < this.max_iterations && max_movement > this.convergence_threshold) {
            max_movement = 0.0;
            HashSet<double[]> new_centroids = new HashSet<double[]>();
            for (Map.Entry<double[], Map<T, double[]>> entry : clusterMap.entrySet()) {
                double[] centroid = entry.getKey();
                Map<T, double[]> elements = entry.getValue();
                ArrayList<double[]> locations = new ArrayList<double[]>(elements.values());
                double[] means = new double[locations.size()];
                int index = 0;
                for (double[] location : locations) {
                    means[index++] = Stats.meanOf((double[])location);
                }
                max_movement = Math.max(max_movement, Math.sqrt(KMeansClusterer.squaredError(centroid, means)));
                new_centroids.add(means);
            }
            clusterMap = this.assignToClusters(object_locations, new_centroids);
        }
        return clusterMap.values();
    }

    protected Map<double[], Map<T, double[]>> assignToClusters(Map<T, double[]> object_locations, Set<double[]> centroids) {
        HashMap<double[], Map<T, double[]>> clusterMap = new HashMap<double[], Map<T, double[]>>();
        for (double[] dArray : centroids) {
            clusterMap.put(dArray, new HashMap());
        }
        for (Map.Entry entry : object_locations.entrySet()) {
            Object object = entry.getKey();
            double[] location = (double[])entry.getValue();
            Iterator<double[]> c_iter = centroids.iterator();
            double[] closest = c_iter.next();
            double distance = KMeansClusterer.squaredError(location, closest);
            while (c_iter.hasNext()) {
                double[] centroid = c_iter.next();
                double dist_cur = KMeansClusterer.squaredError(location, centroid);
                if (!(dist_cur < distance)) continue;
                distance = dist_cur;
                closest = centroid;
            }
            ((Map)clusterMap.get(closest)).put(object, location);
        }
        return clusterMap;
    }

    private static double squaredError(double[] dist, double[] reference) {
        double error = 0.0;
        Preconditions.checkArgument((dist.length == reference.length ? 1 : 0) != 0, (Object)"input arrays must be of the same length");
        for (int i = 0; i < dist.length; ++i) {
            double difference = dist[i] - reference[i];
            error += difference * difference;
        }
        return error;
    }

    public void setRandom(Random random) {
        this.rand = random;
    }

    public static class NotEnoughClustersException
    extends RuntimeException {
        @Override
        public String getMessage() {
            return "Not enough distinct points in the input data set to form the requested number of clusters";
        }
    }
}

