/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.layout.algorithms.FRLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.spatial.BarnesHutQuadTree;
import edu.uci.ics.jung.layout.spatial.ForceObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FRBHVisitorLayoutAlgorithm<N>
extends FRLayoutAlgorithm<N>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(FRBHVisitorLayoutAlgorithm.class);
    private BarnesHutQuadTree<N> tree;

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        super.visit(layoutModel);
        this.tree = new BarnesHutQuadTree(layoutModel.getWidth(), layoutModel.getHeight());
    }

    @Override
    public synchronized void step() {
        this.tree.rebuild(this.layoutModel.getLocations());
        super.step();
    }

    @Override
    protected void calcRepulsion(N node1) {
        Point fvd1 = this.getFRData(node1);
        if (fvd1 == null) {
            return;
        }
        this.frNodeData.put(node1, (Object)Point.ORIGIN);
        ForceObject nodeForceObject = new ForceObject(node1, (Point)this.layoutModel.apply(node1)){

            protected void addForceFrom(ForceObject other) {
                double dx = this.p.x - other.p.x;
                double dy = this.p.y - other.p.y;
                log.trace("dx, dy:{},{}", (Object)dx, (Object)dy);
                double dist = Math.sqrt(dx * dx + dy * dy);
                dist = Math.max(FRBHVisitorLayoutAlgorithm.this.EPSILON, dist);
                log.trace("dist:{}", (Object)dist);
                double force = FRBHVisitorLayoutAlgorithm.this.repulsion_constant * FRBHVisitorLayoutAlgorithm.this.repulsion_constant / dist;
                log.trace("force:{}", (Object)force);
                this.f = this.f.add(force * (dx / dist), force * (dy / dist));
            }
        };
        this.tree.applyForcesTo(nodeForceObject);
        this.frNodeData.put(node1, (Object)nodeForceObject.f);
    }
}

