/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.algorithms;

import com.google.common.graph.Graph;
import edu.uci.ics.jung.algorithms.shortestpath.Distance;
import edu.uci.ics.jung.algorithms.shortestpath.DistanceStatistics;
import edu.uci.ics.jung.algorithms.shortestpath.UnweightedShortestPath;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.RandomLocationTransformer;
import java.util.ConcurrentModificationException;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KKLayoutAlgorithm<N>
extends AbstractIterativeLayoutAlgorithm<N>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(KKLayoutAlgorithm.class);
    private double EPSILON = 0.1;
    private int currentIteration;
    private int maxIterations = 2000;
    private String status = "KKLayout";
    private double L;
    private double K = 1.0;
    private double[][] dm;
    private boolean adjustForGravity = true;
    private boolean exchangenodes = true;
    private N[] nodes;
    private Point[] xydata;
    protected BiFunction<N, N, Number> distance;
    protected double diameter;
    private double length_factor = 0.9;
    private double disconnected_multiplier = 0.5;

    public KKLayoutAlgorithm() {
    }

    public KKLayoutAlgorithm(Distance<N> distance) {
        this.distance = (x, y) -> distance.getDistance(x, y);
    }

    @Override
    public void visit(LayoutModel<N> layoutModel) {
        super.visit(layoutModel);
        Graph<N> graph = layoutModel.getGraph();
        if (graph != null) {
            UnweightedShortestPath distance = new UnweightedShortestPath(graph);
            this.distance = (x, y) -> distance.getDistance((Object)x, (Object)y);
        }
        this.initialize();
    }

    public void setLengthFactor(double length_factor) {
        this.length_factor = length_factor;
    }

    public void setDisconnectedDistanceMultiplier(double disconnected_multiplier) {
        this.disconnected_multiplier = disconnected_multiplier;
    }

    public String getStatus() {
        return this.status + this.layoutModel.getWidth() + " " + this.layoutModel.getHeight();
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public boolean done() {
        return this.currentIteration > this.maxIterations;
    }

    public void initialize() {
        this.currentIteration = 0;
        Graph graph = this.layoutModel.getGraph();
        this.layoutModel.setInitializer(new RandomLocationTransformer(this.layoutModel.getWidth(), (double)this.layoutModel.getHeight(), graph.nodes().size()));
        if (graph != null && this.layoutModel != null) {
            double height = this.layoutModel.getHeight();
            double width = this.layoutModel.getWidth();
            int n = graph.nodes().size();
            this.dm = new double[n][n];
            this.nodes = graph.nodes().toArray();
            this.xydata = new Point[n];
            while (true) {
                try {
                    int index = 0;
                    for (Object node : graph.nodes()) {
                        Point xyd = (Point)this.layoutModel.apply(node);
                        this.nodes[index] = node;
                        this.xydata[index] = xyd;
                        ++index;
                    }
                }
                catch (ConcurrentModificationException index) {
                    continue;
                }
                break;
            }
            this.diameter = DistanceStatistics.diameter(graph, this.distance, true);
            double L0 = Math.min(height, width);
            this.L = L0 / this.diameter * this.length_factor;
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    Number d_ij = this.distance.apply(this.nodes[i], this.nodes[j]);
                    log.trace("distance from " + i + " to " + j + " is " + d_ij);
                    Number d_ji = this.distance.apply(this.nodes[j], this.nodes[i]);
                    log.trace("distance from " + j + " to " + i + " is " + d_ji);
                    double dist = this.diameter * this.disconnected_multiplier;
                    log.trace("dist:" + dist);
                    if (d_ij != null) {
                        dist = Math.min(d_ij.doubleValue(), dist);
                    }
                    if (d_ji != null) {
                        dist = Math.min(d_ji.doubleValue(), dist);
                    }
                    double d = dist;
                    this.dm[j][i] = d;
                    this.dm[i][j] = d;
                }
            }
        }
    }

    @Override
    public void step() {
        int i;
        Graph graph = this.layoutModel.getGraph();
        ++this.currentIteration;
        double energy = this.calcEnergy();
        this.status = "Kamada-Kawai N=" + graph.nodes().size() + "(" + graph.nodes().size() + ") IT: " + this.currentIteration + " E=" + energy;
        int n = graph.nodes().size();
        if (n == 0) {
            return;
        }
        double maxDeltaM = 0.0;
        int pm = -1;
        for (i = 0; i < n; ++i) {
            double deltam;
            if (this.layoutModel.isLocked(this.nodes[i]) || !(maxDeltaM < (deltam = this.calcDeltaM(i)))) continue;
            maxDeltaM = deltam;
            pm = i;
        }
        if (pm == -1) {
            return;
        }
        for (i = 0; i < 100; ++i) {
            double[] dxy = this.calcDeltaXY(pm);
            this.xydata[pm] = Point.of(this.xydata[pm].x + dxy[0], this.xydata[pm].y + dxy[1]);
            double deltam = this.calcDeltaM(pm);
            if (deltam < this.EPSILON) break;
        }
        if (this.adjustForGravity) {
            this.adjustForGravity();
        }
        if (this.exchangenodes && maxDeltaM < this.EPSILON) {
            energy = this.calcEnergy();
            for (i = 0; i < n - 1; ++i) {
                if (this.layoutModel.isLocked(this.nodes[i])) continue;
                for (int j = i + 1; j < n; ++j) {
                    double xenergy;
                    if (this.layoutModel.isLocked(this.nodes[j]) || !(energy > (xenergy = this.calcEnergyIfExchanged(i, j)))) continue;
                    double sx = this.xydata[i].x;
                    double sy = this.xydata[i].y;
                    this.xydata[i] = Point.of(this.xydata[j].x, this.xydata[j].y);
                    this.xydata[j] = Point.of(sx, sy);
                    return;
                }
            }
        }
    }

    public void adjustForGravity() {
        double height = this.layoutModel.getHeight();
        double width = this.layoutModel.getWidth();
        double gx = 0.0;
        double gy = 0.0;
        for (int i = 0; i < this.xydata.length; ++i) {
            gx += this.xydata[i].x;
            gy += this.xydata[i].y;
        }
        double diffx = width / 2.0 - (gx /= (double)this.xydata.length);
        double diffy = height / 2.0 - (gy /= (double)this.xydata.length);
        for (int i = 0; i < this.xydata.length; ++i) {
            this.xydata[i] = this.xydata[i].add(diffx, diffy);
            this.layoutModel.set(this.nodes[i], this.xydata[i]);
        }
    }

    public void setAdjustForGravity(boolean on) {
        this.adjustForGravity = on;
    }

    public boolean getAdjustForGravity() {
        return this.adjustForGravity;
    }

    public void setExchangenodes(boolean on) {
        this.exchangenodes = on;
    }

    public boolean getExchangenodes() {
        return this.exchangenodes;
    }

    private double[] calcDeltaXY(int m) {
        double dE_dxm = 0.0;
        double dE_dym = 0.0;
        double d2E_d2xm = 0.0;
        double d2E_dxmdym = 0.0;
        double d2E_dymdxm = 0.0;
        double d2E_d2ym = 0.0;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m][i];
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].x - this.xydata[i].x;
            double dy = this.xydata[m].y - this.xydata[i].y;
            double d = Math.sqrt(dx * dx + dy * dy);
            double ddd = d * d * d;
            dE_dxm += k_mi * (1.0 - l_mi / d) * dx;
            dE_dym += k_mi * (1.0 - l_mi / d) * dy;
            d2E_d2xm += k_mi * (1.0 - l_mi * dy * dy / ddd);
            d2E_dxmdym += k_mi * l_mi * dx * dy / ddd;
            d2E_d2ym += k_mi * (1.0 - l_mi * dx * dx / ddd);
        }
        d2E_dymdxm = d2E_dxmdym;
        double denomi = d2E_d2xm * d2E_d2ym - d2E_dxmdym * d2E_dymdxm;
        double deltaX = (d2E_dxmdym * dE_dym - d2E_d2ym * dE_dxm) / denomi;
        double deltaY = (d2E_dymdxm * dE_dxm - d2E_d2xm * dE_dym) / denomi;
        return new double[]{deltaX, deltaY};
    }

    private double calcDeltaM(int m) {
        double dEdxm = 0.0;
        double dEdym = 0.0;
        for (int i = 0; i < this.nodes.length; ++i) {
            if (i == m) continue;
            double dist = this.dm[m][i];
            double l_mi = this.L * dist;
            double k_mi = this.K / (dist * dist);
            double dx = this.xydata[m].x - this.xydata[i].x;
            double dy = this.xydata[m].y - this.xydata[i].y;
            double d = Math.sqrt(dx * dx + dy * dy);
            double common = k_mi * (1.0 - l_mi / d);
            dEdxm += common * dx;
            dEdym += common * dy;
        }
        return Math.sqrt(dEdxm * dEdxm + dEdym * dEdym);
    }

    private double calcEnergy() {
        double energy = 0.0;
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            for (int j = i + 1; j < this.nodes.length; ++j) {
                double dist = this.dm[i][j];
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[i].x - this.xydata[j].x;
                double dy = this.xydata[i].y - this.xydata[j].y;
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }

    private double calcEnergyIfExchanged(int p, int q) {
        if (p >= q) {
            throw new RuntimeException("p should be < q");
        }
        double energy = 0.0;
        for (int i = 0; i < this.nodes.length - 1; ++i) {
            for (int j = i + 1; j < this.nodes.length; ++j) {
                int ii = i;
                int jj = j;
                if (i == p) {
                    ii = q;
                }
                if (j == q) {
                    jj = p;
                }
                double dist = this.dm[i][j];
                double l_ij = this.L * dist;
                double k_ij = this.K / (dist * dist);
                double dx = this.xydata[ii].x - this.xydata[jj].x;
                double dy = this.xydata[ii].y - this.xydata[jj].y;
                double d = Math.sqrt(dx * dx + dy * dy);
                energy += k_ij / 2.0 * (dx * dx + dy * dy + l_ij * l_ij - 2.0 * l_ij * d);
            }
        }
        return energy;
    }
}

