/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.layout.algorithms.IterativeLayoutAlgorithm;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.DefaultLayoutModelChangeSupport;
import edu.uci.ics.jung.layout.model.DefaultLayoutStateChangeSupport;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.LayoutChangeListener;
import edu.uci.ics.jung.layout.util.LayoutEvent;
import edu.uci.ics.jung.layout.util.LayoutEventSupport;
import edu.uci.ics.jung.layout.util.VisRunnable;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutModel<N>
implements LayoutModel<N>,
LayoutModel.ChangeSupport,
LayoutEventSupport<N> {
    private static final Logger log = LoggerFactory.getLogger(AbstractLayoutModel.class);
    private Set<N> lockedNodes = Sets.newHashSet();
    protected boolean locked;
    protected int width;
    protected int height;
    protected Graph<N> graph;
    protected VisRunnable visRunnable;
    protected boolean relaxing;
    protected CompletableFuture theFuture;
    protected LayoutModel.ChangeSupport changeSupport = new DefaultLayoutModelChangeSupport();
    private List<LayoutChangeListener<N>> layoutChangeListeners = Lists.newArrayList();
    protected LayoutModel.LayoutStateChangeSupport layoutStateChangeSupport = new DefaultLayoutStateChangeSupport();

    protected AbstractLayoutModel(Graph<N> graph, int width, int height) {
        this.graph = (Graph)Preconditions.checkNotNull(graph);
        this.setSize(width, height);
    }

    @Override
    public void stopRelaxer() {
        if (this.visRunnable != null) {
            this.visRunnable.stop();
        }
        if (this.theFuture != null) {
            this.theFuture.cancel(true);
        }
        this.setRelaxing(false);
    }

    @Override
    public CompletableFuture getTheFuture() {
        return this.theFuture;
    }

    @Override
    public void accept(LayoutAlgorithm<N> layoutAlgorithm) {
        this.layoutStateChangeSupport.fireLayoutStateChanged(this, true);
        log.trace("accepting {}", layoutAlgorithm);
        this.changeSupport.setFireEvents(true);
        if (this.visRunnable != null) {
            log.trace("stopping {}", (Object)this.visRunnable);
            this.visRunnable.stop();
        }
        if (this.theFuture != null) {
            this.theFuture.cancel(true);
        }
        if (log.isTraceEnabled()) {
            log.trace("{} will visit {}", layoutAlgorithm, (Object)this);
        }
        if (layoutAlgorithm != null) {
            layoutAlgorithm.visit(this);
            if (layoutAlgorithm instanceof IterativeLayoutAlgorithm) {
                this.setRelaxing(true);
                this.setupVisRunner((IterativeLayoutAlgorithm)layoutAlgorithm);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace("no visRunner for this {}", (Object)this);
                }
                log.trace("will fire layoutStateCHanged with false");
                this.layoutStateChangeSupport.fireLayoutStateChanged(this, false);
            }
        }
    }

    @Override
    public LayoutModel.LayoutStateChangeSupport getLayoutStateChangeSupport() {
        return this.layoutStateChangeSupport;
    }

    protected void setupVisRunner(IterativeLayoutAlgorithm iterativeContext) {
        log.trace("this {} is setting up a visRunnable with {}", (Object)this, (Object)iterativeContext);
        if (this.visRunnable != null) {
            this.visRunnable.stop();
        }
        if (this.theFuture != null) {
            this.theFuture.cancel(true);
        }
        this.layoutStateChangeSupport.fireLayoutStateChanged(this, true);
        this.changeSupport.setFireEvents(false);
        iterativeContext.preRelax();
        this.changeSupport.setFireEvents(true);
        log.trace("prerelax is done");
        this.visRunnable = new VisRunnable(iterativeContext);
        this.theFuture = CompletableFuture.runAsync(this.visRunnable).thenRun(() -> {
            log.trace("We're done");
            this.setRelaxing(false);
            this.fireChanged();
            this.layoutStateChangeSupport.fireLayoutStateChanged(this, false);
        });
    }

    @Override
    public Graph<N> getGraph() {
        return this.graph;
    }

    @Override
    public void setGraph(Graph<N> graph) {
        this.graph = (Graph)Preconditions.checkNotNull(graph);
        if (log.isTraceEnabled()) {
            log.trace("setGraph to n:{} e:{}", (Object)graph.nodes(), (Object)graph.edges());
        }
    }

    @Override
    public void lock(N node, boolean locked) {
        if (locked) {
            this.lockedNodes.add(node);
        } else {
            this.lockedNodes.remove(node);
        }
    }

    @Override
    public boolean isLocked(N node) {
        return this.lockedNodes.contains(node);
    }

    @Override
    public void lock(boolean locked) {
        log.trace("lock:{}", (Object)locked);
        this.locked = locked;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setSize(int width, int height) {
        if (width == 0 || height == 0) {
            throw new IllegalArgumentException("Can't be zeros " + width + "/" + height);
        }
        int oldWidth = this.width;
        int oldHeight = this.height;
        if (oldWidth == width && oldHeight == height) {
            return;
        }
        if (oldWidth != 0 || oldHeight != 0) {
            this.adjustLocations(oldWidth, oldHeight, width, height);
        }
        this.width = width;
        this.height = height;
    }

    private void adjustLocations(int oldWidth, int oldHeight, int width, int height) {
        if (oldWidth == width && oldHeight == height) {
            return;
        }
        int xOffset = (width - oldWidth) / 2;
        int yOffset = (height - oldHeight) / 2;
        while (true) {
            try {
                for (Object node : this.graph.nodes()) {
                    this.offsetnode(node, xOffset, yOffset);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void set(N node, double x, double y) {
        this.set(node, x, y);
    }

    @Override
    public void set(N node, Point location) {
        if (this.isFireEvents()) {
            this.fireLayoutChanged(node, location);
        }
    }

    protected void offsetnode(N node, double xOffset, double yOffset) {
        if (!this.locked && !this.isLocked(node)) {
            Point p = this.get(node);
            this.set(node, p.x + xOffset, p.y + yOffset);
        }
    }

    @Override
    public boolean isFireEvents() {
        return this.changeSupport.isFireEvents();
    }

    @Override
    public void setFireEvents(boolean fireEvents) {
        this.changeSupport.setFireEvents(fireEvents);
    }

    @Override
    public void addChangeListener(LayoutModel.ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public LayoutModel.ChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    @Override
    public void addLayoutChangeListener(LayoutChangeListener<N> listener) {
        this.layoutChangeListeners.add(listener);
    }

    @Override
    public void removeLayoutChangeListener(LayoutChangeListener<N> listener) {
        this.layoutChangeListeners.remove(listener);
    }

    protected void fireLayoutChanged(N node, Point location) {
        if (this.layoutChangeListeners.size() > 0) {
            LayoutEvent<N> layoutEvent = new LayoutEvent<N>(node, location);
            for (LayoutChangeListener<N> layoutChangeListener : this.layoutChangeListeners) {
                layoutChangeListener.layoutChanged(layoutEvent);
            }
        }
    }

    @Override
    public void removeChangeListener(LayoutModel.ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public boolean isRelaxing() {
        return this.relaxing;
    }

    @Override
    public void setRelaxing(boolean relaxing) {
        log.trace("setRelaxing:{}", (Object)relaxing);
        this.relaxing = relaxing;
    }

    @Override
    public void fireChanged() {
        log.trace("fireChanged");
        this.changeSupport.fireChanged();
    }

    public String toString() {
        return "AbstractLayoutModel{hashCode=" + this.hashCode() + ", width=" + this.width + ", height=" + this.height + ", graph of size =" + this.graph.nodes().size() + '}';
    }
}

