/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.model;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.graph.Graph;
import edu.uci.ics.jung.layout.model.AbstractLayoutModel;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.layout.model.Point;
import edu.uci.ics.jung.layout.util.Caching;
import java.util.Collection;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadingCacheLayoutModel<N>
extends AbstractLayoutModel<N>
implements LayoutModel<N>,
Caching {
    private static final Logger log = LoggerFactory.getLogger(LoadingCacheLayoutModel.class);
    protected LoadingCache<N, Point> locations = CacheBuilder.newBuilder().build(CacheLoader.from(() -> Point.ORIGIN));

    @Override
    public Collection<LayoutModel.ChangeListener> getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    public static <N> Builder<N, ?> builder() {
        return new Builder<N, LoadingCacheLayoutModel<N>>(){

            @Override
            public LoadingCacheLayoutModel<N> build() {
                return new LoadingCacheLayoutModel(this);
            }
        };
    }

    public static <N, P> LoadingCacheLayoutModel<N> from(LoadingCacheLayoutModel<N> other) {
        return new LoadingCacheLayoutModel<N>(other);
    }

    protected LoadingCacheLayoutModel(Builder<N, ?> builder) {
        super(builder.graph, builder.width, builder.height);
        this.locations = builder.locations;
    }

    private LoadingCacheLayoutModel(LoadingCacheLayoutModel<N> other) {
        super(other.graph, other.width, other.height);
    }

    @Override
    public void setInitializer(Function<N, Point> initializer) {
        Function<N, Point> chain = initializer.andThen(p -> Point.of(p.x, p.y));
        this.locations = CacheBuilder.newBuilder().build(CacheLoader.from(chain::apply));
    }

    @Override
    public void setGraph(Graph<N> graph) {
        super.setGraph(graph);
        this.changeSupport.fireChanged();
    }

    @Override
    public void set(N node, Point location) {
        if (!this.locked) {
            this.locations.put(node, (Object)location);
            super.set(node, location);
        }
    }

    @Override
    public void set(N node, double x, double y) {
        this.set(node, Point.of(x, y));
    }

    @Override
    public Point get(N node) {
        if (log.isTraceEnabled()) {
            log.trace(this.locations.getUnchecked(node) + " gotten for " + node);
        }
        return (Point)this.locations.getUnchecked(node);
    }

    @Override
    public Point apply(N node) {
        return this.get(node);
    }

    @Override
    public void clear() {
        this.locations = CacheBuilder.newBuilder().build(CacheLoader.from(() -> Point.ORIGIN));
    }

    public static abstract class Builder<N, T extends LoadingCacheLayoutModel<N>> {
        protected Graph<N> graph;
        protected int width;
        protected int height;
        protected LoadingCache<N, Point> locations = CacheBuilder.newBuilder().build(CacheLoader.from(() -> Point.ORIGIN));

        public Builder<N, T> setGraph(Graph<N> graph) {
            this.graph = (Graph)Preconditions.checkNotNull(graph);
            return this;
        }

        public Builder<N, T> setLayoutModel(LayoutModel<N> layoutModel) {
            this.width = layoutModel.getWidth();
            this.height = layoutModel.getHeight();
            return this;
        }

        public Builder<N, T> setSize(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder<N, T> setInitializer(Function<N, Point> initializer) {
            Function<N, Point> chain = initializer.andThen(p -> Point.of(p.x, p.y));
            this.locations = CacheBuilder.newBuilder().build(CacheLoader.from(chain::apply));
            return this;
        }

        public abstract T build();
    }
}

