/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.model;

import edu.uci.ics.jung.layout.spatial.Circle;
import edu.uci.ics.jung.layout.spatial.Rectangle;
import java.util.Objects;

public class Point {
    public final double x;
    public final double y;
    public static final Point ORIGIN = new Point(0.0, 0.0);

    public static Point of(double x, double y) {
        return new Point(x, y);
    }

    private Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Point add(Point other) {
        return this.add(other.x, other.y);
    }

    public Point add(double dx, double dy) {
        return new Point(this.x + dx, this.y + dy);
    }

    public double distanceSquared(Point other) {
        return this.distanceSquared(other.x, other.y);
    }

    public double distanceSquared(double ox, double oy) {
        double dx = this.x - ox;
        double dy = this.y - oy;
        return dx * dx + dy * dy;
    }

    public boolean inside(Circle c) {
        return this.inside(c.center.x - c.radius, c.center.y - c.radius, c.center.x + c.radius, c.center.y + c.radius) && c.center.distance(this) <= c.radius;
    }

    public boolean inside(Rectangle r) {
        return this.inside(r.x, r.y, r.maxX, r.maxY);
    }

    public boolean inside(double minX, double minY, double maxX, double maxY) {
        return this.x >= minX && maxX >= this.x && this.y >= minY && maxY >= this.y;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public double distance(Point other) {
        return Math.sqrt(this.distanceSquared(other));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        return Double.compare(other.x, this.x) == 0 && Double.compare(other.y, this.y) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y);
    }

    public String toString() {
        return "Point{x=" + this.x + ", y=" + this.y + '}';
    }
}

