/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.layout.util;

import edu.uci.ics.jung.algorithms.util.IterativeContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisRunnable
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(VisRunnable.class);
    private final IterativeContext iterativeContext;
    private long sleepTime = 10L;
    private boolean stop = false;

    public VisRunnable(IterativeContext iterativeContext) {
        log.trace("created a VisRunnable {} for {}", (Object)this.hashCode(), (Object)iterativeContext);
        this.iterativeContext = iterativeContext;
    }

    public void stop() {
        log.trace("told {} to stop", (Object)this);
        this.stop = true;
    }

    @Override
    public void run() {
        while (!this.iterativeContext.done() && !this.stop) {
            try {
                this.iterativeContext.step();
                try {
                    Thread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.iterativeContext.done()) {
            log.trace("done here because {} is done", (Object)this.hashCode());
        }
        if (this.stop) {
            log.trace("done here because {} stop = {}", (Object)this.hashCode(), (Object)this.stop);
        }
    }
}

