/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.algorithms.util.MapSettableTransformer;
import edu.uci.ics.jung.algorithms.util.SettableTransformer;
import edu.uci.ics.jung.io.GraphMLMetadata;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class GraphMLReader<G extends MutableNetwork<N, E>, N, E>
extends DefaultHandler {
    protected SAXParser saxp;
    protected boolean default_directed;
    protected G current_graph;
    protected N current_node = null;
    protected E current_edge = null;
    protected String current_key;
    protected LinkedList<TagState> current_states;
    protected BiMap<String, TagState> tag_state;
    protected Supplier<G> graph_factory;
    protected Supplier<N> node_factory;
    protected Supplier<E> edge_factory;
    protected BiMap<N, String> node_ids;
    protected BiMap<E, String> edge_ids;
    protected Map<String, GraphMLMetadata<G>> graph_metadata;
    protected Map<String, GraphMLMetadata<N>> node_metadata;
    protected Map<String, GraphMLMetadata<E>> edge_metadata;
    protected Map<N, String> node_desc;
    protected Map<E, String> edge_desc;
    protected Map<G, String> graph_desc;
    protected KeyType key_type;
    protected List<G> graphs;
    protected StringBuilder current_text = new StringBuilder();

    public GraphMLReader(Supplier<N> node_factory, Supplier<E> edge_factory) throws ParserConfigurationException, SAXException {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        this.saxp = saxParserFactory.newSAXParser();
        this.current_states = new LinkedList();
        this.tag_state = HashBiMap.create();
        this.tag_state.put((Object)"node", (Object)TagState.NODE);
        this.tag_state.put((Object)"edge", (Object)TagState.EDGE);
        this.tag_state.put((Object)"hyperedge", (Object)TagState.HYPEREDGE);
        this.tag_state.put((Object)"endpoint", (Object)TagState.ENDPOINT);
        this.tag_state.put((Object)"graph", (Object)TagState.GRAPH);
        this.tag_state.put((Object)"data", (Object)TagState.DATA);
        this.tag_state.put((Object)"key", (Object)TagState.KEY);
        this.tag_state.put((Object)"desc", (Object)TagState.DESC);
        this.tag_state.put((Object)"default", (Object)TagState.DEFAULT_KEY);
        this.tag_state.put((Object)"graphml", (Object)TagState.GRAPHML);
        this.key_type = KeyType.NONE;
        this.node_factory = node_factory;
        this.edge_factory = edge_factory;
    }

    public GraphMLReader() throws ParserConfigurationException, SAXException {
        this(null, null);
    }

    public List<G> loadMultiple(Reader reader, Supplier<G> graph_factory) throws IOException {
        this.graph_factory = graph_factory;
        this.initializeData();
        this.clearData();
        this.parse(reader);
        return this.graphs;
    }

    public List<G> loadMultiple(String filename, Supplier<G> graph_factory) throws IOException {
        return this.loadMultiple(new FileReader(filename), graph_factory);
    }

    public void load(Reader reader, G g) throws IOException {
        this.current_graph = g;
        this.graph_factory = null;
        this.initializeData();
        this.clearData();
        this.parse(reader);
    }

    public void load(String filename, G g) throws IOException {
        this.load(new FileReader(filename), g);
    }

    protected void clearData() {
        this.node_ids.clear();
        this.node_desc.clear();
        this.edge_ids.clear();
        this.edge_desc.clear();
        this.graph_desc.clear();
    }

    protected void initializeData() {
        this.node_ids = HashBiMap.create();
        this.node_desc = new HashMap<N, String>();
        this.node_metadata = new HashMap<String, GraphMLMetadata<N>>();
        this.edge_ids = HashBiMap.create();
        this.edge_desc = new HashMap<E, String>();
        this.edge_metadata = new HashMap<String, GraphMLMetadata<E>>();
        this.graph_desc = new HashMap<G, String>();
        this.graph_metadata = new HashMap<String, GraphMLMetadata<G>>();
    }

    protected void parse(Reader reader) throws IOException {
        try {
            this.saxp.parse(new InputSource(reader), (DefaultHandler)this);
            reader.close();
        }
        catch (SAXException saxe) {
            throw new IOException(saxe.getMessage());
        }
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXNotSupportedException {
        String tag = qName.toLowerCase();
        TagState state = (TagState)((Object)this.tag_state.get((Object)tag));
        if (state == null) {
            state = TagState.OTHER;
        }
        switch (state) {
            case GRAPHML: {
                break;
            }
            case NODE: {
                if (this.current_graph == null) {
                    throw new SAXNotSupportedException("Graph must be defined prior to elements");
                }
                if (this.current_edge != null || this.current_node != null) {
                    throw new SAXNotSupportedException("Nesting elements not supported");
                }
                this.createNode(atts);
                break;
            }
            case ENDPOINT: {
                if (this.current_graph == null) {
                    throw new SAXNotSupportedException("Graph must be defined prior to elements");
                }
                if (this.current_edge == null) {
                    throw new SAXNotSupportedException("No edge defined for endpoint");
                }
                if (this.current_states.getFirst() != TagState.HYPEREDGE) {
                    throw new SAXNotSupportedException("Endpoints must be defined inside hyperedge");
                }
                Map<String, String> endpoint_atts = this.getAttributeMap(atts);
                String node = endpoint_atts.remove("node");
                if (node == null) {
                    throw new SAXNotSupportedException("Endpoint must include an 'id' attribute");
                }
                Object v = this.node_ids.inverse().get((Object)node);
                if (v == null) {
                    throw new SAXNotSupportedException("Endpoint refers to nonexistent node ID: " + node);
                }
                this.current_node = v;
                break;
            }
            case EDGE: {
                if (this.current_graph == null) {
                    throw new SAXNotSupportedException("Graph must be defined prior to elements");
                }
                if (this.current_edge != null || this.current_node != null) {
                    throw new SAXNotSupportedException("Nesting elements not supported");
                }
                this.createEdge(atts, state);
                break;
            }
            case HYPEREDGE: {
                throw new SAXNotSupportedException("Hyperedges not supported");
            }
            case GRAPH: {
                if (this.current_graph != null && this.graph_factory != null) {
                    throw new SAXNotSupportedException("Nesting graphs not currently supported");
                }
                if (this.graph_factory != null) {
                    this.current_graph = (MutableNetwork)this.graph_factory.get();
                }
                this.clearData();
                Map<String, String> graph_atts = this.getAttributeMap(atts);
                String default_direction = graph_atts.remove("edgedefault");
                if (default_direction == null) {
                    throw new SAXNotSupportedException("All graphs must specify a default edge direction");
                }
                if (default_direction.equals("directed")) {
                    this.default_directed = true;
                } else if (default_direction.equals("undirected")) {
                    this.default_directed = false;
                } else {
                    throw new SAXNotSupportedException("Invalid or unrecognized default edge direction: " + default_direction);
                }
                this.addExtraData(graph_atts, this.graph_metadata, this.current_graph);
                break;
            }
            case DATA: {
                if (this.current_states.contains((Object)TagState.DATA)) {
                    throw new SAXNotSupportedException("Nested data not supported");
                }
                this.handleData(atts);
                break;
            }
            case KEY: {
                this.createKey(atts);
                break;
            }
        }
        this.current_states.addFirst(state);
    }

    private <T> void addExtraData(Map<String, String> atts, Map<String, GraphMLMetadata<T>> metadata_map, T current_elt) {
        for (Map.Entry<String, GraphMLMetadata<T>> entry : metadata_map.entrySet()) {
            GraphMLMetadata<T> gmlm = entry.getValue();
            if (gmlm.default_value == null) continue;
            SettableTransformer st = (SettableTransformer)gmlm.transformer;
            st.set(current_elt, (Object)gmlm.default_value);
        }
        for (Map.Entry<String, Object> entry : atts.entrySet()) {
            SettableTransformer st;
            String key = entry.getKey();
            GraphMLMetadata<T> key_data = metadata_map.get(key);
            if (key_data != null) {
                if (key_data.default_value != null) continue;
                st = (SettableTransformer)key_data.transformer;
            } else {
                st = new MapSettableTransformer(new HashMap());
                key_data = new GraphMLMetadata(null, null, st);
                metadata_map.put(key, key_data);
            }
            st.set(current_elt, entry.getValue());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXNotSupportedException {
        this.current_text.append(new String(ch, start, length));
    }

    protected <T> void addDatum(Map<String, GraphMLMetadata<T>> metadata, T current_elt, String text) throws SAXNotSupportedException {
        if (!metadata.containsKey(this.current_key)) {
            throw new SAXNotSupportedException("key " + this.current_key + " not valid for element " + current_elt);
        }
        SettableTransformer st = (SettableTransformer)metadata.get((Object)this.current_key).transformer;
        st.set(current_elt, (Object)text);
    }

    @Override
    public void endElement(String uri, String name, String qName) throws SAXNotSupportedException {
        String text = this.current_text.toString().trim();
        this.current_text.setLength(0);
        String tag = qName.toLowerCase();
        TagState state = (TagState)((Object)this.tag_state.get((Object)tag));
        if (state == null) {
            state = TagState.OTHER;
        }
        if (state == TagState.OTHER) {
            return;
        }
        if (state != this.current_states.getFirst()) {
            throw new SAXNotSupportedException("Unbalanced tags: opened " + (String)this.tag_state.inverse().get((Object)this.current_states.getFirst()) + ", closed " + tag);
        }
        block0 : switch (state) {
            case NODE: 
            case ENDPOINT: {
                this.current_node = null;
                break;
            }
            case EDGE: {
                this.current_edge = null;
                break;
            }
            case HYPEREDGE: {
                throw new SAXNotSupportedException("Hypergraphs not currently supported");
            }
            case GRAPH: {
                this.current_graph = null;
                break;
            }
            case KEY: {
                this.current_key = null;
                break;
            }
            case DESC: {
                switch (this.current_states.get(1)) {
                    case GRAPH: {
                        this.graph_desc.put(this.current_graph, text);
                        break block0;
                    }
                    case NODE: 
                    case ENDPOINT: {
                        this.node_desc.put(this.current_node, text);
                        break block0;
                    }
                    case EDGE: 
                    case HYPEREDGE: {
                        this.edge_desc.put(this.current_edge, text);
                        break block0;
                    }
                    case DATA: {
                        switch (this.key_type) {
                            case GRAPH: {
                                this.graph_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                            case NODE: {
                                this.node_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                            case EDGE: {
                                this.edge_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                            case ALL: {
                                this.graph_metadata.get((Object)this.current_key).description = text;
                                this.node_metadata.get((Object)this.current_key).description = text;
                                this.edge_metadata.get((Object)this.current_key).description = text;
                                break block0;
                            }
                        }
                        throw new SAXNotSupportedException("Invalid key type specified for default: " + (Object)((Object)this.key_type));
                    }
                }
                break;
            }
            case DATA: {
                this.key_type = KeyType.NONE;
                switch (this.current_states.get(1)) {
                    case GRAPH: {
                        this.addDatum(this.graph_metadata, this.current_graph, text);
                        break block0;
                    }
                    case NODE: 
                    case ENDPOINT: {
                        this.addDatum(this.node_metadata, this.current_node, text);
                        break block0;
                    }
                    case EDGE: 
                    case HYPEREDGE: {
                        this.addDatum(this.edge_metadata, this.current_edge, text);
                        break block0;
                    }
                }
                break;
            }
            case DEFAULT_KEY: {
                if (this.current_states.get(1) != TagState.KEY) {
                    throw new SAXNotSupportedException("'default' only defined in context of 'key' tag: stack: " + this.current_states.toString());
                }
                switch (this.key_type) {
                    case GRAPH: {
                        this.graph_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                    case NODE: {
                        this.node_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                    case EDGE: {
                        this.edge_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                    case ALL: {
                        this.graph_metadata.get((Object)this.current_key).default_value = text;
                        this.node_metadata.get((Object)this.current_key).default_value = text;
                        this.edge_metadata.get((Object)this.current_key).default_value = text;
                        break block0;
                    }
                }
                throw new SAXNotSupportedException("Invalid key type specified for default: " + (Object)((Object)this.key_type));
            }
        }
        this.current_states.removeFirst();
    }

    protected Map<String, String> getAttributeMap(Attributes atts) {
        HashMap<String, String> att_map = new HashMap<String, String>();
        for (int i = 0; i < atts.getLength(); ++i) {
            att_map.put(atts.getQName(i), atts.getValue(i));
        }
        return att_map;
    }

    protected void handleData(Attributes atts) throws SAXNotSupportedException {
        switch (this.current_states.getFirst()) {
            case GRAPH: {
                break;
            }
            case NODE: 
            case ENDPOINT: {
                break;
            }
            case EDGE: {
                break;
            }
            case HYPEREDGE: {
                break;
            }
            default: {
                throw new SAXNotSupportedException("'data' tag only defined if immediately containing tag is 'graph', 'node', 'edge', or 'hyperedge'");
            }
        }
        this.current_key = this.getAttributeMap(atts).get("key");
        if (this.current_key == null) {
            throw new SAXNotSupportedException("'data' tag requires a key specification");
        }
        if (this.current_key.equals("")) {
            throw new SAXNotSupportedException("'data' tag requires a non-empty key");
        }
        if (!(this.getGraphMetadata().containsKey(this.current_key) || this.getNodeMetadata().containsKey(this.current_key) || this.getEdgeMetadata().containsKey(this.current_key))) {
            throw new SAXNotSupportedException("'data' tag's key specification must reference a defined key");
        }
    }

    protected void createKey(Attributes atts) throws SAXNotSupportedException {
        Map<String, String> key_atts = this.getAttributeMap(atts);
        String id = key_atts.remove("id");
        String for_type = key_atts.remove("for");
        if (for_type == null || for_type.equals("") || for_type.equals("all")) {
            this.node_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
            this.edge_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
            this.graph_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
            this.key_type = KeyType.ALL;
        } else {
            TagState type = (TagState)((Object)this.tag_state.get((Object)for_type));
            switch (type) {
                case NODE: {
                    this.node_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
                    this.key_type = KeyType.NODE;
                    break;
                }
                case EDGE: 
                case HYPEREDGE: {
                    this.edge_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
                    this.key_type = KeyType.EDGE;
                    break;
                }
                case GRAPH: {
                    this.graph_metadata.put(id, new GraphMLMetadata(null, null, new MapSettableTransformer(new HashMap())));
                    this.key_type = KeyType.GRAPH;
                    break;
                }
                default: {
                    throw new SAXNotSupportedException("Invalid metadata target type: " + for_type);
                }
            }
        }
        this.current_key = id;
    }

    protected void createNode(Attributes atts) throws SAXNotSupportedException {
        Map<String, String> node_atts = this.getAttributeMap(atts);
        String id = node_atts.remove("id");
        if (id == null) {
            throw new SAXNotSupportedException("node attribute list missing 'id': " + atts.toString());
        }
        Object v = this.node_ids.inverse().get((Object)id);
        if (v != null) {
            throw new SAXNotSupportedException("Node id \"" + id + " is a duplicate of an existing node ID");
        }
        v = this.node_factory != null ? this.node_factory.get() : id;
        this.node_ids.put(v, (Object)id);
        this.current_graph.addNode(v);
        this.addExtraData(node_atts, this.node_metadata, v);
        this.current_node = v;
    }

    protected void createEdge(Attributes atts, TagState state) throws SAXNotSupportedException {
        Object e;
        Map<String, String> edge_atts = this.getAttributeMap(atts);
        String id = edge_atts.remove("id");
        if (this.edge_factory != null) {
            e = this.edge_factory.get();
        } else if (id != null) {
            e = id;
        } else {
            throw new IllegalArgumentException("If no edge Supplier is supplied, edge id may not be null: " + edge_atts);
        }
        if (id != null) {
            if (this.edge_ids.containsKey(e)) {
                throw new SAXNotSupportedException("Edge id \"" + id + "\" is a duplicate of an existing edge ID");
            }
            this.edge_ids.put(e, (Object)id);
        }
        if (state == TagState.EDGE) {
            this.assignEdgeSourceTarget(e, atts, edge_atts);
        }
        this.addExtraData(edge_atts, this.edge_metadata, e);
        this.current_edge = e;
    }

    protected void assignEdgeSourceTarget(E e, Attributes atts, Map<String, String> edge_atts) throws SAXNotSupportedException {
        String source_id = edge_atts.remove("source");
        if (source_id == null) {
            throw new SAXNotSupportedException("edge attribute list missing 'source': " + atts.toString());
        }
        Object source = this.node_ids.inverse().get((Object)source_id);
        if (source == null) {
            throw new SAXNotSupportedException("specified 'source' attribute \"" + source_id + "\" does not match any node ID");
        }
        String target_id = edge_atts.remove("target");
        if (target_id == null) {
            throw new SAXNotSupportedException("edge attribute list missing 'target': " + atts.toString());
        }
        Object target = this.node_ids.inverse().get((Object)target_id);
        if (target == null) {
            throw new SAXNotSupportedException("specified 'target' attribute \"" + target_id + "\" does not match any node ID");
        }
        String directed = edge_atts.remove("directed");
        if (directed != null) {
            boolean isDirected = directed.equals("true");
            boolean isUndirected = directed.equals("false");
            if (!isDirected && !isUndirected) {
                throw new SAXNotSupportedException("Unrecognized edge direction specifier 'direction=\"" + directed + "\"': source: " + source_id + ", target: " + target_id);
            }
            if (isDirected != this.default_directed) {
                throw new SAXNotSupportedException(String.format("Parser does not support graphs with directed and undirected edges; default direction: %b, edge direction: %b: ", this.default_directed, isDirected ? isDirected : isUndirected));
            }
        }
        this.current_graph.addEdge(source, target, e);
    }

    public BiMap<N, String> getNodeIDs() {
        return this.node_ids;
    }

    public BiMap<E, String> getEdgeIDs() {
        return this.edge_ids;
    }

    public Map<String, GraphMLMetadata<G>> getGraphMetadata() {
        return this.graph_metadata;
    }

    public Map<String, GraphMLMetadata<N>> getNodeMetadata() {
        return this.node_metadata;
    }

    public Map<String, GraphMLMetadata<E>> getEdgeMetadata() {
        return this.edge_metadata;
    }

    public Map<G, String> getGraphDescriptions() {
        return this.graph_desc;
    }

    public Map<N, String> getNodeDescriptions() {
        return this.node_desc;
    }

    public Map<E, String> getEdgeDescriptions() {
        return this.edge_desc;
    }

    protected static enum KeyType {
        NONE,
        NODE,
        EDGE,
        GRAPH,
        ALL;

    }

    protected static enum TagState {
        NO_TAG,
        NODE,
        EDGE,
        HYPEREDGE,
        ENDPOINT,
        GRAPH,
        DATA,
        KEY,
        DESC,
        DEFAULT_KEY,
        GRAPHML,
        OTHER;

    }
}

