/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import com.google.common.graph.MutableNetwork;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.AbstractMetadata;
import edu.uci.ics.jung.io.graphml.DataMetadata;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class GraphElementParser<G extends MutableNetwork<N, E>, N, E>
extends AbstractElementParser<G, N, E> {
    public GraphElementParser(ParserContext<G, N, E> parserContext) {
        super(parserContext);
    }

    @Override
    public GraphMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            GraphMetadata graphMetadata = new GraphMetadata();
            Iterator<Attribute> iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (graphMetadata.getId() == null && "id".equals(name)) {
                    graphMetadata.setId(value);
                    continue;
                }
                if (graphMetadata.getEdgeDefault() == null && "edgedefault".equals(name)) {
                    graphMetadata.setEdgeDefault("directed".equals(value) ? GraphMetadata.EdgeDefault.DIRECTED : GraphMetadata.EdgeDefault.UNDIRECTED);
                    continue;
                }
                graphMetadata.setProperty(name, value);
            }
            if (graphMetadata.getEdgeDefault() == null) {
                throw new GraphIOException("Element 'graph' is missing attribute 'edgedefault'");
            }
            HashMap idToNodeMap = new HashMap();
            LinkedList<EdgeMetadata> edgeMetadata = new LinkedList<EdgeMetadata>();
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    AbstractMetadata metadata;
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("desc".equals(name)) {
                        String desc = (String)this.getParser(name).parse(xmlEventReader, element);
                        graphMetadata.setDescription(desc);
                    } else if ("data".equals(name)) {
                        DataMetadata data = (DataMetadata)this.getParser(name).parse(xmlEventReader, element);
                        graphMetadata.addData(data);
                    } else if ("node".equals(name)) {
                        metadata = (NodeMetadata)this.getParser(name).parse(xmlEventReader, element);
                        Object node = this.getParserContext().createNode((NodeMetadata)metadata);
                        ((NodeMetadata)metadata).setNode(node);
                        idToNodeMap.put(((NodeMetadata)metadata).getId(), node);
                        graphMetadata.addNodeMetadata(node, (NodeMetadata)metadata);
                    } else if ("edge".equals(name)) {
                        metadata = (EdgeMetadata)this.getParser(name).parse(xmlEventReader, element);
                        if (((EdgeMetadata)metadata).isDirected() == null) {
                            ((EdgeMetadata)metadata).setDirected(graphMetadata.getEdgeDefault() == GraphMetadata.EdgeDefault.DIRECTED);
                        }
                        Object edge = this.getParserContext().createEdge((EdgeMetadata)metadata);
                        edgeMetadata.add((EdgeMetadata)metadata);
                        ((EdgeMetadata)metadata).setEdge(edge);
                        graphMetadata.addEdgeMetadata(edge, (EdgeMetadata)metadata);
                    } else {
                        this.getUnknownParser().parse(xmlEventReader, element);
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            this.applyKeys(graphMetadata);
            Object graph = this.getParserContext().createGraph(graphMetadata);
            graphMetadata.setGraph(graph);
            this.addNodesToGraph(graph, idToNodeMap.values());
            this.addEdgesToGraph(graph, edgeMetadata, idToNodeMap);
            return graphMetadata;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }

    private void addNodesToGraph(G graph, Collection<N> nodes) {
        for (N node : nodes) {
            graph.addNode(node);
        }
    }

    private void addEdgesToGraph(G graph, Collection<EdgeMetadata> metadata, Map<String, N> idToNodeMap) throws GraphIOException {
        for (EdgeMetadata emd : metadata) {
            Object edge = emd.getEdge();
            N source = idToNodeMap.get(emd.getSource());
            N target = idToNodeMap.get(emd.getTarget());
            if (source == null || target == null) {
                throw new GraphIOException("edge references undefined source or target node. Source: " + emd.getSource() + ", Target: " + emd.getTarget());
            }
            graph.addEdge(source, target, edge);
        }
    }
}

