/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.Graph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Traverser;
import edu.uci.ics.jung.graph.MutableCTreeNetwork;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

class DelegateCTreeNetwork<N, E>
extends AbstractNetwork<N, E>
implements MutableCTreeNetwork<N, E> {
    private final MutableNetwork<N, E> delegate;
    private final Map<N, Integer> depths;
    private Optional<Integer> height;
    private Optional<N> root;

    DelegateCTreeNetwork(MutableNetwork<N, E> graph, Optional<N> root) {
        this.delegate = (MutableNetwork)Preconditions.checkNotNull(graph, (Object)"graph");
        this.depths = new HashMap<N, Integer>();
        this.setRoot((Optional)Preconditions.checkNotNull(root, (Object)"root"));
    }

    @Override
    public Optional<N> root() {
        return this.root;
    }

    @Override
    public Optional<N> predecessor(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Set predecessors = this.delegate.predecessors(node);
        Preconditions.checkState((predecessors.size() <= 1 ? 1 : 0) != 0);
        return predecessors.isEmpty() ? Optional.empty() : Optional.of(Iterables.getOnlyElement((Iterable)predecessors));
    }

    @Override
    public Optional<E> inEdge(N node) {
        Set inEdges = this.delegate.inEdges(node);
        Preconditions.checkState((inEdges.size() <= 1 ? 1 : 0) != 0);
        return inEdges.isEmpty() ? Optional.empty() : Optional.of(Iterables.getOnlyElement((Iterable)inEdges));
    }

    @Override
    public int depth(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.depths.get(node);
    }

    @Override
    public Optional<Integer> height() {
        if (!this.root.isPresent()) {
            return Optional.empty();
        }
        if (!this.height.isPresent()) {
            this.calculateHeight();
        }
        return this.height;
    }

    @Override
    public boolean isDirected() {
        return true;
    }

    @Override
    public boolean allowsSelfLoops() {
        return false;
    }

    public Set<N> adjacentNodes(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.adjacentNodes(node);
    }

    public int degree(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.degree(node);
    }

    public int inDegree(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.inDegree(node);
    }

    public ElementOrder<N> nodeOrder() {
        return this.delegate.nodeOrder();
    }

    public Set<N> nodes() {
        return this.delegate.nodes();
    }

    public int outDegree(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.outDegree(node);
    }

    public Set<N> predecessors(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.predecessors(node);
    }

    public Set<N> successors(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.successors(node);
    }

    public Set<E> edges() {
        return this.delegate.edges();
    }

    public Set<E> adjacentEdges(E edge) {
        Preconditions.checkNotNull(edge, (Object)"edge");
        return this.delegate.adjacentEdges(edge);
    }

    @Override
    public boolean allowsParallelEdges() {
        return false;
    }

    public Graph<N> asGraph() {
        return this.delegate.asGraph();
    }

    public ElementOrder<E> edgeOrder() {
        return this.delegate.edgeOrder();
    }

    public Set<E> edgesConnecting(N nodeU, N nodeV) {
        Preconditions.checkNotNull(nodeU, (Object)"nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"nodeV");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(nodeU), (String)"Node %s is not an element of this tree.", nodeU);
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(nodeV), (String)"Node %s is not an element of this tree.", nodeV);
        return this.delegate.edgesConnecting(nodeU, nodeV);
    }

    public Optional<E> edgeConnecting(N nodeU, N nodeV) {
        return this.delegate.edgeConnecting(nodeU, nodeV);
    }

    public E edgeConnectingOrNull(N nodeU, N nodeV) {
        return (E)this.delegate.edgeConnectingOrNull(nodeU, nodeV);
    }

    public boolean hasEdgeConnecting(N nodeU, N nodeV) {
        return this.delegate.hasEdgeConnecting(nodeU, nodeV);
    }

    public Set<E> inEdges(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.inEdges(node);
    }

    public Set<E> incidentEdges(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.incidentEdges(node);
    }

    public EndpointPair<N> incidentNodes(E edge) {
        Preconditions.checkNotNull(edge, (Object)"edge");
        Preconditions.checkArgument((boolean)this.delegate.edges().contains(edge), (String)"Edge %s is not an element of this tree.", edge);
        return this.delegate.incidentNodes(edge);
    }

    public Set<E> outEdges(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        Preconditions.checkArgument((boolean)this.delegate.nodes().contains(node), (String)"Node %s is not an element of this tree.", node);
        return this.delegate.outEdges(node);
    }

    @Override
    public boolean addNode(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        if (this.root.isPresent()) {
            N rootValue = this.root.get();
            Preconditions.checkArgument((boolean)rootValue.equals(node), (String)"Cannot add node %s, as node %s is already the root of this tree.", node, rootValue);
            return false;
        }
        this.setRoot(Optional.of(node));
        return true;
    }

    @Override
    public boolean addEdge(N nodeU, N nodeV, E edge) {
        Preconditions.checkNotNull(nodeU, (Object)"nodeU");
        Preconditions.checkNotNull(nodeV, (Object)"nodeV");
        Preconditions.checkNotNull(edge, (Object)"edge");
        Preconditions.checkArgument((!nodeU.equals(nodeV) ? 1 : 0) != 0, (String)"Cannot add self-loop edge on node %s, as self-loops are not allowed.", nodeU);
        if (!this.root.isPresent()) {
            this.setRoot(Optional.of(nodeU));
        } else {
            Preconditions.checkArgument((boolean)this.nodes().contains(nodeU), (String)"Cannot add edge from nodeU %s to nodeV %s, as nodeU %s is not an element of this tree.", nodeU, nodeV, nodeU);
            if (this.successors((Object)nodeU).contains(nodeV)) {
                return false;
            }
            Preconditions.checkArgument((!this.nodes().contains(nodeV) ? 1 : 0) != 0, (String)"Cannot add edge from nodeU %s to nodeV %s, as nodeV %s is an element of this tree.", nodeU, nodeV, nodeV);
        }
        this.setDepth(nodeV, nodeU);
        return this.delegate.addEdge(nodeU, nodeV, edge);
    }

    private void setDepth(N node, N parent) {
        if (parent == null) {
            this.depths.put(node, 0);
            this.height = Optional.of(0);
        } else {
            this.depths.putIfAbsent(parent, 0);
            int nodeDepth = Math.max(this.depths.get(parent) + 1, this.height.orElse(0));
            this.depths.put(node, nodeDepth);
            this.height = Optional.of(nodeDepth);
        }
    }

    private void calculateHeight() {
        int currentHeight = 0;
        ArrayList currentLevel = new ArrayList(this.successors((Object)this.root.orElseThrow(AssertionError::new)));
        while (!currentLevel.isEmpty()) {
            ArrayList nextLevel = new ArrayList();
            ++currentHeight;
            for (Object node : currentLevel) {
                nextLevel.addAll(this.successors(node));
            }
            currentLevel = nextLevel;
        }
        this.height = Optional.of(currentHeight);
    }

    @Override
    public boolean removeNode(N node) {
        Preconditions.checkNotNull(node, (Object)"node");
        if (!this.nodes().contains(node)) {
            return false;
        }
        for (Object nodeToRemove : Traverser.forTree(this.delegate).breadthFirst(node)) {
            this.delegate.removeNode(nodeToRemove);
            this.depths.remove(nodeToRemove);
        }
        if (this.root.isPresent() && this.root.get().equals(node)) {
            this.setRoot(Optional.empty());
        }
        this.height = Optional.empty();
        return true;
    }

    private void setRoot(Optional<N> root) {
        this.root = root;
        this.root.ifPresent(node -> {
            this.delegate.addNode(node);
            this.setDepth(node, null);
        });
    }

    @Override
    public boolean removeEdge(E edge) {
        Preconditions.checkNotNull(edge, (Object)"edge");
        this.delegate.removeEdge(edge);
        return this.removeNode(this.delegate.incidentNodes(edge).target());
    }
}

