/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import edu.uci.ics.jung.graph.CTree;
import edu.uci.ics.jung.graph.DelegateCTree;
import edu.uci.ics.jung.graph.MutableCTree;
import java.util.Optional;

public class TreeBuilder<N> {
    ElementOrder<N> nodeOrder = ElementOrder.insertion();
    Optional<Integer> expectedNodeCount = Optional.empty();
    Optional<N> root = Optional.empty();

    public static TreeBuilder<Object> builder() {
        return new TreeBuilder<Object>();
    }

    public static <N> TreeBuilder<N> from(CTree<N> tree) {
        return new TreeBuilder<N>().nodeOrder(tree.nodeOrder());
    }

    public <N1 extends N> TreeBuilder<N1> withRoot(N1 root) {
        Preconditions.checkNotNull(root);
        TreeBuilder<N1> newBuilder = this.cast();
        newBuilder.root = Optional.of(root);
        return newBuilder;
    }

    public TreeBuilder<N> expectedNodeCount(int expectedNodeCount) {
        Preconditions.checkArgument((expectedNodeCount >= 0 ? 1 : 0) != 0);
        this.expectedNodeCount = Optional.of(expectedNodeCount);
        return this;
    }

    public <N1 extends N> TreeBuilder<N1> nodeOrder(ElementOrder<N1> nodeOrder) {
        TreeBuilder<N1> newBuilder = this.cast();
        newBuilder.nodeOrder = (ElementOrder)Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <N1 extends N> MutableCTree<N1> build() {
        GraphBuilder graphBuilder = GraphBuilder.directed().allowsSelfLoops(false);
        if (this.expectedNodeCount.isPresent()) {
            graphBuilder = graphBuilder.expectedNodeCount(this.expectedNodeCount.get().intValue());
        }
        MutableGraph delegate = graphBuilder.nodeOrder(this.nodeOrder).build();
        Optional<N> rootCast = this.root;
        return new DelegateCTree<N>(delegate, rootCast);
    }

    private <N1 extends N> TreeBuilder<N1> cast() {
        return this;
    }
}

