/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import com.google.common.base.Preconditions;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import edu.uci.ics.jung.graph.CTreeNetwork;
import edu.uci.ics.jung.graph.DelegateCTreeNetwork;
import edu.uci.ics.jung.graph.MutableCTreeNetwork;
import java.util.Optional;

public class TreeNetworkBuilder<N, E> {
    ElementOrder<N> nodeOrder = ElementOrder.insertion();
    ElementOrder<E> edgeOrder = ElementOrder.insertion();
    Optional<Integer> expectedNodeCount = Optional.empty();
    Optional<N> root = Optional.empty();

    public static TreeNetworkBuilder<Object, Object> builder() {
        return new TreeNetworkBuilder<Object, Object>();
    }

    public static <N, E> TreeNetworkBuilder<N, E> from(CTreeNetwork<N, E> tree) {
        return new TreeNetworkBuilder<N, E>().nodeOrder(tree.nodeOrder());
    }

    public <N1 extends N> TreeNetworkBuilder<N1, E> withRoot(N1 root) {
        Preconditions.checkNotNull(root);
        TreeNetworkBuilder newBuilder = this.cast();
        newBuilder.root = Optional.of(root);
        return newBuilder;
    }

    public TreeNetworkBuilder<N, E> expectedNodeCount(int expectedNodeCount) {
        Preconditions.checkArgument((expectedNodeCount >= 0 ? 1 : 0) != 0);
        this.expectedNodeCount = Optional.of(expectedNodeCount);
        return this;
    }

    public <N1 extends N> TreeNetworkBuilder<N1, E> nodeOrder(ElementOrder<N1> nodeOrder) {
        TreeNetworkBuilder newBuilder = this.cast();
        newBuilder.nodeOrder = (ElementOrder)Preconditions.checkNotNull(nodeOrder);
        return newBuilder;
    }

    public <E1 extends E> TreeNetworkBuilder<N, E1> edgeOrder(ElementOrder<E1> edgeOrder) {
        TreeNetworkBuilder newBuilder = this.cast();
        newBuilder.edgeOrder = (ElementOrder)Preconditions.checkNotNull(edgeOrder);
        return newBuilder;
    }

    public <N1 extends N, E1 extends E> MutableCTreeNetwork<N1, E1> build() {
        NetworkBuilder graphBuilder = NetworkBuilder.directed().allowsSelfLoops(false).allowsParallelEdges(false);
        if (this.expectedNodeCount.isPresent()) {
            graphBuilder = graphBuilder.expectedNodeCount(this.expectedNodeCount.get().intValue());
        }
        MutableNetwork delegate = graphBuilder.nodeOrder(this.nodeOrder).edgeOrder(this.edgeOrder).build();
        Optional<N> rootCast = this.root;
        return new DelegateCTreeNetwork(delegate, rootCast);
    }

    private <N1 extends N, E1 extends E> TreeNetworkBuilder<N1, E1> cast() {
        return this;
    }
}

