/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.Graph;
import com.google.common.graph.Graphs;
import com.google.common.graph.Network;
import edu.uci.ics.jung.graph.CTreeNetwork;
import edu.uci.ics.jung.graph.MutableCTreeNetwork;
import edu.uci.ics.jung.graph.TreeNetworkBuilder;

public class TreeUtils {
    public static <N> ImmutableSet<N> roots(Graph<N> graph) {
        Preconditions.checkNotNull(graph, (Object)"graph");
        return (ImmutableSet)graph.nodes().stream().filter(node -> graph.predecessors(node).isEmpty()).collect(ImmutableSet.toImmutableSet());
    }

    public static <N> boolean isForestShaped(Graph<N> graph) {
        Preconditions.checkNotNull(graph, (Object)"graph");
        return graph.isDirected() && !Graphs.hasCycle(graph) && graph.nodes().stream().allMatch(node -> graph.predecessors(node).size() <= 1);
    }

    public static <N> boolean isForestShaped(Network<N, ?> graph) {
        Preconditions.checkNotNull(graph, (Object)"graph");
        return graph.isDirected() && !Graphs.hasCycle(graph) && graph.nodes().stream().allMatch(node -> graph.predecessors(node).size() <= 1);
    }

    public static <N, E> MutableCTreeNetwork<N, E> getSubTree(CTreeNetwork<N, E> tree, N root) {
        Preconditions.checkNotNull(tree, (Object)"tree");
        Preconditions.checkNotNull(root, (Object)"root");
        Preconditions.checkArgument((boolean)tree.nodes().contains(root), (Object)"Input tree does not contain the input subtree root");
        MutableCTreeNetwork subtree = TreeNetworkBuilder.from(tree).withRoot(root).build();
        TreeUtils.growSubTree(tree, subtree, root);
        return subtree;
    }

    public static <N, E> void growSubTree(CTreeNetwork<N, E> tree, MutableCTreeNetwork<N, E> subTree, N root) {
        Preconditions.checkNotNull(tree, (Object)"tree");
        Preconditions.checkNotNull(subTree, (Object)"subTree");
        Preconditions.checkNotNull(root, (Object)"root");
        for (Object kid : tree.successors(root)) {
            Object edge = tree.edgesConnecting(root, kid).iterator().next();
            subTree.addEdge(root, kid, edge);
            TreeUtils.growSubTree(tree, subTree, kid);
        }
    }

    public static <N, E> void addSubTree(MutableCTreeNetwork<N, E> tree, CTreeNetwork<N, E> subTree, N subTreeParent, E connectingEdge) {
        Preconditions.checkNotNull(tree, (Object)"tree");
        Preconditions.checkNotNull(subTree, (Object)"subTree");
        Preconditions.checkNotNull(subTreeParent, (Object)"subTreeParent");
        Preconditions.checkNotNull(connectingEdge, (Object)"connectingEdge");
        Preconditions.checkArgument((boolean)tree.nodes().contains(subTreeParent), (Object)"'tree' does not contain 'subTreeParent'");
        if (!subTree.root().isPresent()) {
            return;
        }
        Object subTreeRoot = subTree.root().get();
        tree.addEdge(subTreeParent, subTreeRoot, connectingEdge);
        TreeUtils.addFromSubTree(tree, subTree, subTreeRoot);
    }

    private static <N, E> void addFromSubTree(MutableCTreeNetwork<N, E> tree, CTreeNetwork<N, E> subTree, N subTreeRoot) {
        Preconditions.checkNotNull(tree, (Object)"tree");
        Preconditions.checkNotNull(subTree, (Object)"subTree");
        Preconditions.checkNotNull(subTreeRoot, (Object)"subTreeRoot");
        for (Object edge : subTree.outEdges(subTreeRoot)) {
            Object child = subTree.incidentNodes(edge).target();
            tree.addEdge(subTreeRoot, child, edge);
            TreeUtils.addFromSubTree(tree, subTree, child);
        }
    }
}

