/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import java.util.HashSet;
import java.util.Iterator;

public class TestGraphs {
    public static String[][] pairs = new String[][]{{"a", "b", "3"}, {"a", "c", "4"}, {"a", "d", "5"}, {"d", "c", "6"}, {"d", "e", "7"}, {"e", "f", "8"}, {"f", "g", "9"}, {"h", "i", "1"}};

    public static Network<String, Number> createTestGraph(boolean directed) {
        MutableNetwork graph = directed ? NetworkBuilder.directed().allowsParallelEdges(true).build() : NetworkBuilder.undirected().allowsParallelEdges(true).build();
        for (int i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i];
            graph.addEdge((Object)pair[0], (Object)pair[1], (Object)Integer.parseInt(pair[2]));
        }
        return graph;
    }

    public static Network<String, Number> createChainPlusIsolates(int chain_length, int isolate_count) {
        MutableNetwork g = NetworkBuilder.undirected().allowsParallelEdges(true).build();
        if (chain_length > 0) {
            String[] v = new String[chain_length];
            v[0] = "v0";
            g.addNode((Object)v[0]);
            for (int i = 1; i < chain_length; ++i) {
                v[i] = "v" + i;
                g.addNode((Object)v[i]);
                g.addEdge((Object)v[i], (Object)v[i - 1], (Object)new Double(Math.random()));
            }
        }
        for (int i = 0; i < isolate_count; ++i) {
            String v = "v" + (chain_length + i);
            g.addNode((Object)v);
        }
        return g;
    }

    public static Network<String, Number> createDirectedAcyclicGraph(int layers, int maxNodesPerLayer, double linkprob) {
        MutableNetwork dag = NetworkBuilder.directed().allowsParallelEdges(true).build();
        HashSet previousLayers = new HashSet();
        HashSet<String> inThisLayer = new HashSet<String>();
        for (int i = 0; i < layers; ++i) {
            int nodesThisLayer = (int)(Math.random() * (double)maxNodesPerLayer) + 1;
            for (int j = 0; j < nodesThisLayer; ++j) {
                String v = i + ":" + j;
                dag.addNode((Object)v);
                inThisLayer.add(v);
                for (String v2 : previousLayers) {
                    if (!(Math.random() < linkprob)) continue;
                    Double de = new Double(Math.random());
                    dag.addEdge((Object)v, (Object)v2, (Object)de);
                }
            }
            previousLayers.addAll(inThisLayer);
            inThisLayer.clear();
        }
        return dag;
    }

    private static void createEdge(MutableNetwork<String, Number> g, String v1Label, String v2Label, int weight) {
        g.addEdge((Object)v1Label, (Object)v2Label, (Object)new Double(Math.random()));
    }

    public static Network<String, Number> getOneComponentGraph() {
        String i2;
        String i1;
        int j;
        int i;
        MutableNetwork g = NetworkBuilder.undirected().allowsParallelEdges(true).build();
        for (i = 1; i <= 10; ++i) {
            for (j = i + 1; j <= 10; ++j) {
                i1 = "" + i;
                i2 = "" + j;
                g.addEdge((Object)i1, (Object)i2, (Object)Math.pow(i + 2, j));
            }
        }
        for (i = 11; i <= 20; ++i) {
            for (j = i + 1; j <= 20; ++j) {
                if (Math.random() > 0.6) continue;
                i1 = "" + i;
                i2 = "" + j;
                g.addEdge((Object)i1, (Object)i2, (Object)Math.pow(i + 2, j));
            }
        }
        Iterator nodeIt = g.nodes().iterator();
        String current = (String)nodeIt.next();
        int i3 = 0;
        while (nodeIt.hasNext()) {
            String next = (String)nodeIt.next();
            g.addEdge((Object)current, (Object)next, (Object)new Integer(i3++));
        }
        return g;
    }

    public static Network<String, Number> getDemoGraph() {
        String i2;
        String i1;
        int i;
        MutableNetwork g = NetworkBuilder.undirected().allowsParallelEdges(true).build();
        for (i = 0; i < pairs.length; ++i) {
            String[] pair = pairs[i];
            TestGraphs.createEdge((MutableNetwork<String, Number>)g, pair[0], pair[1], Integer.parseInt(pair[2]));
        }
        for (i = 1; i <= 10; ++i) {
            for (int j = i + 1; j <= 10; ++j) {
                i1 = "c" + i;
                i2 = "c" + j;
                g.addEdge((Object)i1, (Object)i2, (Object)Math.pow(i + 2, j));
            }
        }
        for (i = 11; i <= 20; ++i) {
            for (int j = i + 1; j <= 20; ++j) {
                if (Math.random() > 0.6) continue;
                i1 = "p" + i;
                i2 = "p" + j;
                g.addEdge((Object)i1, (Object)i2, (Object)Math.pow(i + 2, j));
            }
        }
        return g;
    }
}

