/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import com.google.common.graph.Network;
import edu.uci.ics.jung.layout.algorithms.LayoutAlgorithm;
import edu.uci.ics.jung.layout.model.LayoutModel;
import edu.uci.ics.jung.visualization.BaseVisualizationModel;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.MouseListenerTranslator;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.util.function.Function;
import javax.swing.ToolTipManager;

public class VisualizationViewer<N, E>
extends BasicVisualizationServer<N, E> {
    protected Function<? super N, String> nodeToolTipFunction;
    protected Function<? super E, String> edgeToolTipFunction;
    protected Function<MouseEvent, String> mouseEventToolTipFunction;
    protected GraphMouse graphMouse;
    protected MouseListener requestFocusListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            VisualizationViewer.this.requestFocusInWindow();
        }
    };

    public VisualizationViewer(Network<N, E> network, Dimension size) {
        this(network, size, size);
    }

    public VisualizationViewer(Network<N, E> network, Dimension layoutSize, Dimension viewSize) {
        this(network, null, layoutSize, viewSize);
    }

    public VisualizationViewer(Network<N, E> network, LayoutAlgorithm<N> layoutAlgorithm, Dimension layoutSize, Dimension viewSize) {
        this(new BaseVisualizationModel<N, E>(network, layoutAlgorithm, layoutSize), viewSize);
    }

    public VisualizationViewer(Network<N, E> network, LayoutAlgorithm<N> layoutAlgorithm, Dimension preferredSize) {
        this(new BaseVisualizationModel<N, E>(network, layoutAlgorithm, preferredSize), preferredSize);
    }

    public VisualizationViewer(VisualizationModel<N, E> model, Dimension preferredSize) {
        super(model, preferredSize);
        this.setFocusable(true);
        this.addMouseListener(this.requestFocusListener);
    }

    public void setGraphMouse(GraphMouse graphMouse) {
        this.graphMouse = graphMouse;
        MouseListener[] ml = this.getMouseListeners();
        for (int i = 0; i < ml.length; ++i) {
            if (!(ml[i] instanceof GraphMouse)) continue;
            this.removeMouseListener(ml[i]);
        }
        MouseMotionListener[] mml = this.getMouseMotionListeners();
        for (int i = 0; i < mml.length; ++i) {
            if (!(mml[i] instanceof GraphMouse)) continue;
            this.removeMouseMotionListener(mml[i]);
        }
        MouseWheelListener[] mwl = this.getMouseWheelListeners();
        for (int i = 0; i < mwl.length; ++i) {
            if (!(mwl[i] instanceof GraphMouse)) continue;
            this.removeMouseWheelListener(mwl[i]);
        }
        this.addMouseListener(graphMouse);
        this.addMouseMotionListener(graphMouse);
        this.addMouseWheelListener(graphMouse);
    }

    public GraphMouse getGraphMouse() {
        return this.graphMouse;
    }

    public void addGraphMouseListener(GraphMouseListener<N> gel) {
        this.addMouseListener(new MouseListenerTranslator(gel, this));
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
    }

    public void setEdgeToolTipFunction(Function<? super E, String> edgeToolTipFunction) {
        this.edgeToolTipFunction = edgeToolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setMouseEventToolTipFunction(Function<MouseEvent, String> mouseEventToolTipFunction) {
        this.mouseEventToolTipFunction = mouseEventToolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setNodeToolTipFunction(Function<? super N, String> nodeToolTipFunction) {
        this.nodeToolTipFunction = nodeToolTipFunction;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        LayoutModel layoutModel = this.getModel().getLayoutModel();
        Point2D p = null;
        if (this.nodeToolTipFunction != null) {
            p = this.getTransformSupport().inverseTransform(this, event.getPoint());
            Object node = this.getPickSupport().getNode(layoutModel, p.getX(), p.getY());
            if (node != null) {
                return this.nodeToolTipFunction.apply(node);
            }
        }
        if (this.edgeToolTipFunction != null) {
            Object edge;
            if (p == null) {
                p = this.renderContext.getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, event.getPoint());
            }
            if ((edge = this.getPickSupport().getEdge(layoutModel, p.getX(), p.getY())) != null) {
                return this.edgeToolTipFunction.apply(edge);
            }
        }
        if (this.mouseEventToolTipFunction != null) {
            return this.mouseEventToolTipFunction.apply(event);
        }
        return super.getToolTipText(event);
    }

    public static interface GraphMouse
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener {
    }
}

