/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.annotations;

import edu.uci.ics.jung.visualization.MultiLayerTransformer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.annotations.Annotation;
import edu.uci.ics.jung.visualization.annotations.AnnotationPaintable;
import edu.uci.ics.jung.visualization.annotations.AnnotationRenderer;
import edu.uci.ics.jung.visualization.transform.AffineTransformer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.HashSet;

public class AnnotationManager {
    protected AnnotationRenderer annotationRenderer = new AnnotationRenderer();
    protected AnnotationPaintable lowerAnnotationPaintable;
    protected AnnotationPaintable upperAnnotationPaintable;
    protected RenderContext<?, ?> rc;
    protected AffineTransformer transformer;

    public AnnotationManager(RenderContext<?, ?> rc) {
        this.rc = rc;
        this.lowerAnnotationPaintable = new AnnotationPaintable(rc, this.annotationRenderer);
        this.upperAnnotationPaintable = new AnnotationPaintable(rc, this.annotationRenderer);
        MutableTransformer mt = rc.getMultiLayerTransformer().getTransformer(MultiLayerTransformer.Layer.LAYOUT);
        if (mt instanceof AffineTransformer) {
            this.transformer = (AffineTransformer)((Object)mt);
        } else if (mt instanceof LensTransformer) {
            this.transformer = (AffineTransformer)((Object)((LensTransformer)mt).getDelegate());
        }
    }

    public AnnotationPaintable getAnnotationPaintable(Annotation.Layer layer) {
        if (layer == Annotation.Layer.LOWER) {
            return this.lowerAnnotationPaintable;
        }
        if (layer == Annotation.Layer.UPPER) {
            return this.upperAnnotationPaintable;
        }
        return null;
    }

    public void add(Annotation.Layer layer, Annotation<?> annotation) {
        if (layer == Annotation.Layer.LOWER) {
            this.lowerAnnotationPaintable.add(annotation);
        }
        if (layer == Annotation.Layer.UPPER) {
            this.upperAnnotationPaintable.add(annotation);
        }
    }

    public void remove(Annotation<?> annotation) {
        this.lowerAnnotationPaintable.remove(annotation);
        this.upperAnnotationPaintable.remove(annotation);
    }

    protected AnnotationPaintable getLowerAnnotationPaintable() {
        return this.lowerAnnotationPaintable;
    }

    protected AnnotationPaintable getUpperAnnotationPaintable() {
        return this.upperAnnotationPaintable;
    }

    public Annotation<?> getAnnotation(Point2D p) {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.lowerAnnotationPaintable.getAnnotations());
        annotations.addAll(this.upperAnnotationPaintable.getAnnotations());
        return this.getAnnotation(p, annotations);
    }

    public Annotation<?> getAnnotation(Point2D p, Collection<Annotation> annotations) {
        double closestDistance = Double.MAX_VALUE;
        Annotation closestAnnotation = null;
        for (Annotation annotation : annotations) {
            double distanceSq;
            Point2D ip;
            Object ann = annotation.getAnnotation();
            if (ann instanceof Shape) {
                Rectangle2D shapeBounds;
                Point2D.Double shapeCenter;
                double distanceSq2;
                Shape shape = (Shape)ann;
                ip = this.rc.getMultiLayerTransformer().inverseTransform(p);
                if (!shape.contains(ip) || !((distanceSq2 = (shapeCenter = new Point2D.Double((shapeBounds = shape.getBounds2D()).getCenterX(), shapeBounds.getCenterY())).distanceSq(ip)) < closestDistance)) continue;
                closestDistance = distanceSq2;
                closestAnnotation = annotation;
                continue;
            }
            if (!(ann instanceof String)) continue;
            ip = this.rc.getMultiLayerTransformer().inverseTransform(MultiLayerTransformer.Layer.VIEW, p);
            Point2D ap = annotation.getLocation();
            String label = (String)ann;
            Component component = this.prepareRenderer(this.rc, this.annotationRenderer, label);
            AffineTransform base = new AffineTransform(this.transformer.getTransform());
            double rotation = this.transformer.getRotation();
            AffineTransform unrotate = AffineTransform.getRotateInstance(-rotation, ap.getX(), ap.getY());
            base.concatenate(unrotate);
            Dimension d = component.getPreferredSize();
            Rectangle2D.Double componentBounds = new Rectangle2D.Double(ap.getX(), ap.getY(), d.width, d.height);
            Shape componentBoundsShape = base.createTransformedShape(componentBounds);
            Point2D.Double componentCenter = new Point2D.Double(componentBoundsShape.getBounds().getCenterX(), componentBoundsShape.getBounds().getCenterY());
            if (!componentBoundsShape.contains(ip) || !((distanceSq = componentCenter.distanceSq(ip)) < closestDistance)) continue;
            closestDistance = distanceSq;
            closestAnnotation = annotation;
        }
        return closestAnnotation;
    }

    public Component prepareRenderer(RenderContext<?, ?> rc, AnnotationRenderer annotationRenderer, Object value) {
        return annotationRenderer.getAnnotationRendererComponent(rc.getScreenDevice(), value);
    }
}

